/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.bankpayment.db.BankReconciliationLine;
import com.axelor.apps.bankpayment.db.BankStatement;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BANKPAYMENT_BANK_RECONCILIATION", indexes={@Index(columnList="name"), @Index(columnList="company"), @Index(columnList="journal"), @Index(columnList="currency"), @Index(columnList="bank_details"), @Index(columnList="cash_account"), @Index(columnList="bank_statement"), @Index(columnList="validated_by_user")})
public class BankReconciliation
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BANKPAYMENT_BANK_RECONCILIATION_SEQ")
    @SequenceGenerator(name="BANKPAYMENT_BANK_RECONCILIATION_SEQ", sequenceName="BANKPAYMENT_BANK_RECONCILIATION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Label")
    @NameColumn
    private String name;
    @Widget(title="Company")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="From Date")
    private LocalDate fromDate;
    @Widget(title="To Date")
    private LocalDate toDate;
    @Widget(title="Journal")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Journal journal;
    @Widget(title="Currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Bank details")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails bankDetails;
    @Widget(title="Cash account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account cashAccount;
    @Widget(title="Starting Balance")
    private BigDecimal startingBalance = BigDecimal.ZERO;
    @Widget(title="Ending Balance")
    private BigDecimal endingBalance = BigDecimal.ZERO;
    @Widget(title="Account balance")
    private BigDecimal accountBalance = BigDecimal.ZERO;
    @Widget(title="Bank Reconciliation Lines")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="bankReconciliation", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BankReconciliationLine> bankReconciliationLineList;
    @Widget(title="Computed Balance", readonly=true)
    private BigDecimal computedBalance = BigDecimal.ZERO;
    @Widget(title="Status", readonly=true, selection="bankpayment.bank.reconciliation.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Bank statement")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankStatement bankStatement;
    @Widget(title="Total paid", readonly=true)
    private BigDecimal totalPaid = BigDecimal.ZERO;
    @Widget(title="Total cashed", readonly=true)
    private BigDecimal totalCashed = BigDecimal.ZERO;
    @Widget(title="Include other bank statements")
    private Boolean includeOtherBankStatements = Boolean.FALSE;
    @Widget(title="Validated By", readonly=true)
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User validatedByUser;
    @Widget(title="Validated On", readonly=true)
    private LocalDate validatedDate;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public BankReconciliation() {
    }

    public BankReconciliation(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public Journal getJournal() {
        return this.journal;
    }

    public void setJournal(Journal journal) {
        this.journal = journal;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public BankDetails getBankDetails() {
        return this.bankDetails;
    }

    public void setBankDetails(BankDetails bankDetails) {
        this.bankDetails = bankDetails;
    }

    public Account getCashAccount() {
        return this.cashAccount;
    }

    public void setCashAccount(Account cashAccount) {
        this.cashAccount = cashAccount;
    }

    public BigDecimal getStartingBalance() {
        return this.startingBalance == null ? BigDecimal.ZERO : this.startingBalance;
    }

    public void setStartingBalance(BigDecimal startingBalance) {
        this.startingBalance = startingBalance;
    }

    public BigDecimal getEndingBalance() {
        return this.endingBalance == null ? BigDecimal.ZERO : this.endingBalance;
    }

    public void setEndingBalance(BigDecimal endingBalance) {
        this.endingBalance = endingBalance;
    }

    public BigDecimal getAccountBalance() {
        return this.accountBalance == null ? BigDecimal.ZERO : this.accountBalance;
    }

    public void setAccountBalance(BigDecimal accountBalance) {
        this.accountBalance = accountBalance;
    }

    public List<BankReconciliationLine> getBankReconciliationLineList() {
        return this.bankReconciliationLineList;
    }

    public void setBankReconciliationLineList(List<BankReconciliationLine> bankReconciliationLineList) {
        this.bankReconciliationLineList = bankReconciliationLineList;
    }

    public void addBankReconciliationLineListItem(BankReconciliationLine item) {
        if (this.getBankReconciliationLineList() == null) {
            this.setBankReconciliationLineList(new ArrayList<BankReconciliationLine>());
        }
        this.getBankReconciliationLineList().add(item);
        item.setBankReconciliation(this);
    }

    public void removeBankReconciliationLineListItem(BankReconciliationLine item) {
        if (this.getBankReconciliationLineList() == null) {
            return;
        }
        this.getBankReconciliationLineList().remove((Object)item);
    }

    public void clearBankReconciliationLineList() {
        if (this.getBankReconciliationLineList() != null) {
            this.getBankReconciliationLineList().clear();
        }
    }

    public BigDecimal getComputedBalance() {
        return this.computedBalance == null ? BigDecimal.ZERO : this.computedBalance;
    }

    public void setComputedBalance(BigDecimal computedBalance) {
        this.computedBalance = computedBalance;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public BankStatement getBankStatement() {
        return this.bankStatement;
    }

    public void setBankStatement(BankStatement bankStatement) {
        this.bankStatement = bankStatement;
    }

    public BigDecimal getTotalPaid() {
        return this.totalPaid == null ? BigDecimal.ZERO : this.totalPaid;
    }

    public void setTotalPaid(BigDecimal totalPaid) {
        this.totalPaid = totalPaid;
    }

    public BigDecimal getTotalCashed() {
        return this.totalCashed == null ? BigDecimal.ZERO : this.totalCashed;
    }

    public void setTotalCashed(BigDecimal totalCashed) {
        this.totalCashed = totalCashed;
    }

    public Boolean getIncludeOtherBankStatements() {
        return this.includeOtherBankStatements == null ? Boolean.FALSE : this.includeOtherBankStatements;
    }

    public void setIncludeOtherBankStatements(Boolean includeOtherBankStatements) {
        this.includeOtherBankStatements = includeOtherBankStatements;
    }

    public User getValidatedByUser() {
        return this.validatedByUser;
    }

    public void setValidatedByUser(User validatedByUser) {
        this.validatedByUser = validatedByUser;
    }

    public LocalDate getValidatedDate() {
        return this.validatedDate;
    }

    public void setValidatedDate(LocalDate validatedDate) {
        this.validatedDate = validatedDate;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BankReconciliation)) {
            return false;
        }
        BankReconciliation other = (BankReconciliation)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("startingBalance", (Object)this.getStartingBalance()).add("endingBalance", (Object)this.getEndingBalance()).add("accountBalance", (Object)this.getAccountBalance()).add("computedBalance", (Object)this.getComputedBalance()).add("statusSelect", (Object)this.getStatusSelect()).add("totalPaid", (Object)this.getTotalPaid()).add("totalCashed", (Object)this.getTotalCashed()).add("includeOtherBankStatements", (Object)this.getIncludeOtherBankStatements()).omitNullValues().toString();
    }
}

