/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.bankpayment.db.BankReconciliation;
import com.axelor.apps.bankpayment.db.BankStatementLine;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BANKPAYMENT_BANK_RECONCILIATION_LINE", indexes={@Index(columnList="name"), @Index(columnList="bank_reconciliation"), @Index(columnList="partner"), @Index(columnList="account"), @Index(columnList="bank_statement_line"), @Index(columnList="move_line")})
public class BankReconciliationLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BANKPAYMENT_BANK_RECONCILIATION_LINE_SEQ")
    @SequenceGenerator(name="BANKPAYMENT_BANK_RECONCILIATION_LINE_SEQ", sequenceName="BANKPAYMENT_BANK_RECONCILIATION_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Label", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    @NameColumn
    private String name;
    @Widget(title="Bank Reconciliation")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankReconciliation bankReconciliation;
    @Widget(title="Effect Date")
    @NotNull
    private LocalDate effectDate;
    @Widget(title="Reference")
    private String reference;
    @Widget(title="Partner")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Partner partner;
    @Widget(title="Type", selection="bankpayment.bank.reconciliation.type.select")
    private Integer typeSelect = 0;
    @Widget(title="Accounting.Account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account account;
    @Widget(title="Debit")
    private BigDecimal debit = BigDecimal.ZERO;
    @Widget(title="Credit")
    private BigDecimal credit = BigDecimal.ZERO;
    @Widget(title="Bank Statement detail")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankStatementLine bankStatementLine;
    @Widget(title="Move Line")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MoveLine moveLine;
    @Widget(title="Is posted", readonly=true)
    private Boolean isPosted = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public BankReconciliationLine() {
    }

    public BankReconciliationLine(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BankReconciliation getBankReconciliation() {
        return this.bankReconciliation;
    }

    public void setBankReconciliation(BankReconciliation bankReconciliation) {
        this.bankReconciliation = bankReconciliation;
    }

    public LocalDate getEffectDate() {
        return this.effectDate;
    }

    public void setEffectDate(LocalDate effectDate) {
        this.effectDate = effectDate;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Partner getPartner() {
        return this.partner;
    }

    public void setPartner(Partner partner) {
        this.partner = partner;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public BigDecimal getDebit() {
        return this.debit == null ? BigDecimal.ZERO : this.debit;
    }

    public void setDebit(BigDecimal debit) {
        this.debit = debit;
    }

    public BigDecimal getCredit() {
        return this.credit == null ? BigDecimal.ZERO : this.credit;
    }

    public void setCredit(BigDecimal credit) {
        this.credit = credit;
    }

    public BankStatementLine getBankStatementLine() {
        return this.bankStatementLine;
    }

    public void setBankStatementLine(BankStatementLine bankStatementLine) {
        this.bankStatementLine = bankStatementLine;
    }

    public MoveLine getMoveLine() {
        return this.moveLine;
    }

    public void setMoveLine(MoveLine moveLine) {
        this.moveLine = moveLine;
    }

    public Boolean getIsPosted() {
        return this.isPosted == null ? Boolean.FALSE : this.isPosted;
    }

    public void setIsPosted(Boolean isPosted) {
        this.isPosted = isPosted;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BankReconciliationLine)) {
            return false;
        }
        BankReconciliationLine other = (BankReconciliationLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("effectDate", (Object)this.getEffectDate()).add("reference", (Object)this.getReference()).add("typeSelect", (Object)this.getTypeSelect()).add("debit", (Object)this.getDebit()).add("credit", (Object)this.getCredit()).add("isPosted", (Object)this.getIsPosted()).omitNullValues().toString();
    }
}

