/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.db;

import com.axelor.apps.bankpayment.db.BankStatementFileFormat;
import com.axelor.apps.bankpayment.db.EbicsPartner;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BANKPAYMENT_BANK_STATEMENT", indexes={@Index(columnList="name"), @Index(columnList="ebics_partner"), @Index(columnList="bank_statement_file_format"), @Index(columnList="bank_statement_file")})
public class BankStatement
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BANKPAYMENT_BANK_STATEMENT_SEQ")
    @SequenceGenerator(name="BANKPAYMENT_BANK_STATEMENT_SEQ", sequenceName="BANKPAYMENT_BANK_STATEMENT_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Label")
    @NameColumn
    private String name;
    @Widget(title="From Date")
    private LocalDate fromDate;
    @Widget(title="To Date")
    private LocalDate toDate;
    @Widget(title="Status", readonly=true, selection="bankpayment.bank.statement.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Ebics Partner")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EbicsPartner ebicsPartner;
    @Widget(title="File format")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankStatementFileFormat bankStatementFileFormat;
    @Widget(title="File")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile bankStatementFile;
    @Widget(title="Get date")
    private LocalDateTime getDateTime;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public BankStatement() {
    }

    public BankStatement(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LocalDate getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDate fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public EbicsPartner getEbicsPartner() {
        return this.ebicsPartner;
    }

    public void setEbicsPartner(EbicsPartner ebicsPartner) {
        this.ebicsPartner = ebicsPartner;
    }

    public BankStatementFileFormat getBankStatementFileFormat() {
        return this.bankStatementFileFormat;
    }

    public void setBankStatementFileFormat(BankStatementFileFormat bankStatementFileFormat) {
        this.bankStatementFileFormat = bankStatementFileFormat;
    }

    public MetaFile getBankStatementFile() {
        return this.bankStatementFile;
    }

    public void setBankStatementFile(MetaFile bankStatementFile) {
        this.bankStatementFile = bankStatementFile;
    }

    public LocalDateTime getGetDateTime() {
        return this.getDateTime;
    }

    public void setGetDateTime(LocalDateTime getDateTime) {
        this.getDateTime = getDateTime;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BankStatement)) {
            return false;
        }
        BankStatement other = (BankStatement)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("statusSelect", (Object)this.getStatusSelect()).add("getDateTime", (Object)this.getGetDateTime()).omitNullValues().toString();
    }
}

