/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.db;

import com.axelor.apps.account.db.InterbankCodeLine;
import com.axelor.apps.bankpayment.db.BankStatement;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Currency;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BANKPAYMENT_BANK_STATEMENT_LINE")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class BankStatementLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BANKPAYMENT_BANK_STATEMENT_LINE_SEQ")
    @SequenceGenerator(name="BANKPAYMENT_BANK_STATEMENT_LINE_SEQ", sequenceName="BANKPAYMENT_BANK_STATEMENT_LINE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Operation date")
    private LocalDate operationDate;
    @Widget(title="Value date")
    private LocalDate valueDate;
    @Widget(title="Debit")
    private BigDecimal debit = BigDecimal.ZERO;
    @Widget(title="Credit")
    private BigDecimal credit = BigDecimal.ZERO;
    @Widget(title="Currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @Widget(title="Bank details")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankDetails bankDetails;
    @Widget(title="Rejects/Return Reason Code")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InterbankCodeLine operationInterbankCodeLine;
    @Widget(title="Operation Code")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InterbankCodeLine rejectInterbankCodeLine;
    @Widget(title="Description", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Reference")
    private String reference;
    @Widget(title="Origin")
    private String origin;
    @Widget(title="Bank statement")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankStatement bankStatement;
    @Widget(title="Sequence")
    private Integer sequence = 0;
    @Widget(title="Amount remaining to reconcile")
    private BigDecimal amountRemainToReconcile = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public LocalDate getOperationDate() {
        return this.operationDate;
    }

    public void setOperationDate(LocalDate operationDate) {
        this.operationDate = operationDate;
    }

    public LocalDate getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(LocalDate valueDate) {
        this.valueDate = valueDate;
    }

    public BigDecimal getDebit() {
        return this.debit == null ? BigDecimal.ZERO : this.debit;
    }

    public void setDebit(BigDecimal debit) {
        this.debit = debit;
    }

    public BigDecimal getCredit() {
        return this.credit == null ? BigDecimal.ZERO : this.credit;
    }

    public void setCredit(BigDecimal credit) {
        this.credit = credit;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public BankDetails getBankDetails() {
        return this.bankDetails;
    }

    public void setBankDetails(BankDetails bankDetails) {
        this.bankDetails = bankDetails;
    }

    public InterbankCodeLine getOperationInterbankCodeLine() {
        return this.operationInterbankCodeLine;
    }

    public void setOperationInterbankCodeLine(InterbankCodeLine operationInterbankCodeLine) {
        this.operationInterbankCodeLine = operationInterbankCodeLine;
    }

    public InterbankCodeLine getRejectInterbankCodeLine() {
        return this.rejectInterbankCodeLine;
    }

    public void setRejectInterbankCodeLine(InterbankCodeLine rejectInterbankCodeLine) {
        this.rejectInterbankCodeLine = rejectInterbankCodeLine;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public BankStatement getBankStatement() {
        return this.bankStatement;
    }

    public void setBankStatement(BankStatement bankStatement) {
        this.bankStatement = bankStatement;
    }

    public Integer getSequence() {
        return this.sequence == null ? 0 : this.sequence;
    }

    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    public BigDecimal getAmountRemainToReconcile() {
        return this.amountRemainToReconcile == null ? BigDecimal.ZERO : this.amountRemainToReconcile;
    }

    public void setAmountRemainToReconcile(BigDecimal amountRemainToReconcile) {
        this.amountRemainToReconcile = amountRemainToReconcile;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BankStatementLine)) {
            return false;
        }
        BankStatementLine other = (BankStatementLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("operationDate", (Object)this.getOperationDate()).add("valueDate", (Object)this.getValueDate()).add("debit", (Object)this.getDebit()).add("credit", (Object)this.getCredit()).add("reference", (Object)this.getReference()).add("origin", (Object)this.getOrigin()).add("sequence", (Object)this.getSequence()).add("amountRemainToReconcile", (Object)this.getAmountRemainToReconcile()).omitNullValues().toString();
    }
}

