/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.db;

import com.axelor.apps.bankpayment.db.EbicsBank;
import com.axelor.apps.base.db.Batch;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BANKPAYMENT_EBICS_CERTIFICATE", indexes={@Index(columnList="ebics_bank"), @Index(columnList="fullName")})
public class EbicsCertificate
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BANKPAYMENT_EBICS_CERTIFICATE_SEQ")
    @SequenceGenerator(name="BANKPAYMENT_EBICS_CERTIFICATE_SEQ", sequenceName="BANKPAYMENT_EBICS_CERTIFICATE_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Bank")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EbicsBank ebicsBank;
    @Widget(title="Type", selection="bankpayment.ebics.certificate.type.select")
    @NotNull
    private String typeSelect;
    @Widget(title="Valid from")
    private LocalDate validFrom;
    @Widget(title="Valid to")
    private LocalDate validTo;
    @Widget(title="Issuer")
    private String issuer;
    @Widget(title="Subject")
    private String subject;
    @Widget(title="Certificate")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    private byte[] certificate;
    @Widget(title="Serial")
    private String serial;
    @Widget(title="PrivateKey")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    private byte[] privateKey;
    @Widget(title="PublicKeyModulus", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String publicKeyModulus;
    @Widget(title="PublicKeyExponent", multiline=true)
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String publicKeyExponent;
    @Widget(title="Full name")
    @NameColumn
    private String fullName;
    @Widget(title="PEM")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String pemString;
    @Widget(title="SHA2(256)")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String sha2has;
    @Widget(title="Initialization Letter edition date")
    private LocalDateTime initLetterEditionDate;
    @Widget(title="Batchs")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Batch> batchSet;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EbicsBank getEbicsBank() {
        return this.ebicsBank;
    }

    public void setEbicsBank(EbicsBank ebicsBank) {
        this.ebicsBank = ebicsBank;
    }

    public String getTypeSelect() {
        return this.typeSelect;
    }

    public void setTypeSelect(String typeSelect) {
        this.typeSelect = typeSelect;
    }

    public LocalDate getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(LocalDate validFrom) {
        this.validFrom = validFrom;
    }

    public LocalDate getValidTo() {
        return this.validTo;
    }

    public void setValidTo(LocalDate validTo) {
        this.validTo = validTo;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public byte[] getCertificate() {
        return this.certificate;
    }

    public void setCertificate(byte[] certificate) {
        this.certificate = certificate;
    }

    public String getSerial() {
        return this.serial;
    }

    public void setSerial(String serial) {
        this.serial = serial;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(byte[] privateKey) {
        this.privateKey = privateKey;
    }

    public String getPublicKeyModulus() {
        return this.publicKeyModulus;
    }

    public void setPublicKeyModulus(String publicKeyModulus) {
        this.publicKeyModulus = publicKeyModulus;
    }

    public String getPublicKeyExponent() {
        return this.publicKeyExponent;
    }

    public void setPublicKeyExponent(String publicKeyExponent) {
        this.publicKeyExponent = publicKeyExponent;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getPemString() {
        return this.pemString;
    }

    public void setPemString(String pemString) {
        this.pemString = pemString;
    }

    public String getSha2has() {
        return this.sha2has;
    }

    public void setSha2has(String sha2has) {
        this.sha2has = sha2has;
    }

    public LocalDateTime getInitLetterEditionDate() {
        return this.initLetterEditionDate;
    }

    public void setInitLetterEditionDate(LocalDateTime initLetterEditionDate) {
        this.initLetterEditionDate = initLetterEditionDate;
    }

    public Set<Batch> getBatchSet() {
        return this.batchSet;
    }

    public void setBatchSet(Set<Batch> batchSet) {
        this.batchSet = batchSet;
    }

    public void addBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            this.setBatchSet(new HashSet<Batch>());
        }
        this.getBatchSet().add(item);
    }

    public void removeBatchSetItem(Batch item) {
        if (this.getBatchSet() == null) {
            return;
        }
        this.getBatchSet().remove((Object)item);
    }

    public void clearBatchSet() {
        if (this.getBatchSet() != null) {
            this.getBatchSet().clear();
        }
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EbicsCertificate)) {
            return false;
        }
        EbicsCertificate other = (EbicsCertificate)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("typeSelect", (Object)this.getTypeSelect()).add("validFrom", (Object)this.getValidFrom()).add("validTo", (Object)this.getValidTo()).add("issuer", (Object)this.getIssuer()).add("subject", (Object)this.getSubject()).add("serial", (Object)this.getSerial()).add("fullName", (Object)this.getFullName()).add("initLetterEditionDate", (Object)this.getInitLetterEditionDate()).omitNullValues().toString();
    }
}

