/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.db;

import com.axelor.apps.bankpayment.db.BankOrderFileFormat;
import com.axelor.apps.bankpayment.db.BankStatementFileFormat;
import com.axelor.apps.bankpayment.db.EbicsCertificate;
import com.axelor.apps.bankpayment.db.EbicsPartner;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BANKPAYMENT_EBICS_USER", indexes={@Index(columnList="name"), @Index(columnList="fullName"), @Index(columnList="ebics_partner"), @Index(columnList="associated_user"), @Index(columnList="a005certificate"), @Index(columnList="e002certificate"), @Index(columnList="x002certificate"), @Index(columnList="test_data_file"), @Index(columnList="test_signature_file"), @Index(columnList="test_signatory_ebics_user"), @Index(columnList="test_bank_statement_file_format"), @Index(columnList="test_bank_order_file_format")})
public class EbicsUser
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="BANKPAYMENT_EBICS_USER_SEQ")
    @SequenceGenerator(name="BANKPAYMENT_EBICS_USER_SEQ", sequenceName="BANKPAYMENT_EBICS_USER_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Security medium")
    private String securityMedium = "0000";
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Full name")
    @NameColumn
    private String fullName;
    @Widget(title="User id")
    @NotNull
    @Size(max=35)
    private String userId;
    @Widget(title="Next order id", readonly=true)
    private String nextOrderId;
    @Widget(title="Password", password=true)
    private String password;
    @Widget(title="User type", selection="bankpayment.ebics.user.user.type.select")
    private Integer userTypeSelect = 0;
    @Widget(title="Status", readonly=true, selection="bankpayment.account.ebics.user.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Ebics partner")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EbicsPartner ebicsPartner;
    @Widget(title="Associated user")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User associatedUser;
    @Widget(title="dn")
    private String dn;
    @Widget(title="Certificate (a005)")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EbicsCertificate a005Certificate;
    @Widget(title="Certificate (e002)")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EbicsCertificate e002Certificate;
    @Widget(title="Certificate (x002)")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EbicsCertificate x002Certificate;
    @Widget(title="Test data file")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile testDataFile;
    @Widget(title="Test signature file")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile testSignatureFile;
    @Widget(title="Signatory user")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EbicsUser testSignatoryEbicsUser;
    @Widget(title="Bank statement file format")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankStatementFileFormat testBankStatementFileFormat;
    @Widget(title="Bank order file format")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BankOrderFileFormat testBankOrderFileFormat;
    @Widget(title="Serial number (CORP)")
    private String serialNumber;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public EbicsUser() {
    }

    public EbicsUser(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSecurityMedium() {
        return this.securityMedium;
    }

    public void setSecurityMedium(String securityMedium) {
        this.securityMedium = securityMedium;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getNextOrderId() {
        return this.nextOrderId;
    }

    public void setNextOrderId(String nextOrderId) {
        this.nextOrderId = nextOrderId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getUserTypeSelect() {
        return this.userTypeSelect == null ? 0 : this.userTypeSelect;
    }

    public void setUserTypeSelect(Integer userTypeSelect) {
        this.userTypeSelect = userTypeSelect;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public EbicsPartner getEbicsPartner() {
        return this.ebicsPartner;
    }

    public void setEbicsPartner(EbicsPartner ebicsPartner) {
        this.ebicsPartner = ebicsPartner;
    }

    public User getAssociatedUser() {
        return this.associatedUser;
    }

    public void setAssociatedUser(User associatedUser) {
        this.associatedUser = associatedUser;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public EbicsCertificate getA005Certificate() {
        return this.a005Certificate;
    }

    public void setA005Certificate(EbicsCertificate a005Certificate) {
        this.a005Certificate = a005Certificate;
    }

    public EbicsCertificate getE002Certificate() {
        return this.e002Certificate;
    }

    public void setE002Certificate(EbicsCertificate e002Certificate) {
        this.e002Certificate = e002Certificate;
    }

    public EbicsCertificate getX002Certificate() {
        return this.x002Certificate;
    }

    public void setX002Certificate(EbicsCertificate x002Certificate) {
        this.x002Certificate = x002Certificate;
    }

    public MetaFile getTestDataFile() {
        return this.testDataFile;
    }

    public void setTestDataFile(MetaFile testDataFile) {
        this.testDataFile = testDataFile;
    }

    public MetaFile getTestSignatureFile() {
        return this.testSignatureFile;
    }

    public void setTestSignatureFile(MetaFile testSignatureFile) {
        this.testSignatureFile = testSignatureFile;
    }

    public EbicsUser getTestSignatoryEbicsUser() {
        return this.testSignatoryEbicsUser;
    }

    public void setTestSignatoryEbicsUser(EbicsUser testSignatoryEbicsUser) {
        this.testSignatoryEbicsUser = testSignatoryEbicsUser;
    }

    public BankStatementFileFormat getTestBankStatementFileFormat() {
        return this.testBankStatementFileFormat;
    }

    public void setTestBankStatementFileFormat(BankStatementFileFormat testBankStatementFileFormat) {
        this.testBankStatementFileFormat = testBankStatementFileFormat;
    }

    public BankOrderFileFormat getTestBankOrderFileFormat() {
        return this.testBankOrderFileFormat;
    }

    public void setTestBankOrderFileFormat(BankOrderFileFormat testBankOrderFileFormat) {
        this.testBankOrderFileFormat = testBankOrderFileFormat;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EbicsUser)) {
            return false;
        }
        EbicsUser other = (EbicsUser)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("securityMedium", (Object)this.getSecurityMedium()).add("name", (Object)this.getName()).add("fullName", (Object)this.getFullName()).add("userId", (Object)this.getUserId()).add("nextOrderId", (Object)this.getNextOrderId()).add("userTypeSelect", (Object)this.getUserTypeSelect()).add("statusSelect", (Object)this.getStatusSelect()).add("dn", (Object)this.getDn()).add("serialNumber", (Object)this.getSerialNumber()).omitNullValues().toString();
    }
}

