/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.db.repo;

import com.axelor.apps.bankpayment.db.BankOrderLine;
import com.axelor.apps.bankpayment.db.BankOrderLineOrigin;
import com.axelor.apps.bankpayment.db.repo.BankOrderLineRepository;
import com.axelor.apps.tool.StringTool;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public class BankOrderLineManagementRepository
extends BankOrderLineRepository {
    public Map<String, Object> populate(Map<String, Object> json, Map<String, Object> context) {
        Long bankOrderLineId = (Long)json.get("id");
        BankOrderLine bankOrderLine = (BankOrderLine)((Object)this.find(bankOrderLineId));
        String pieceReferenceList = "";
        String pieceDateList = "";
        String pieceDueDateList = "";
        boolean bFirst = true;
        for (BankOrderLineOrigin bankOrderLineOrigin : bankOrderLine.getBankOrderLineOriginList()) {
            if (bFirst) {
                pieceReferenceList = pieceReferenceList + this.changeNullToEmptyString(bankOrderLineOrigin.getRelatedToSelectName());
                pieceDateList = pieceDateList + this.changeDateToString(bankOrderLineOrigin.getRelatedToSelectDate());
                pieceDueDateList = pieceDueDateList + this.changeDateToString(bankOrderLineOrigin.getRelatedToSelectDueDate());
                bFirst = false;
                continue;
            }
            pieceReferenceList = pieceReferenceList + "," + this.changeNullToEmptyString(bankOrderLineOrigin.getRelatedToSelectName());
            pieceDateList = pieceDateList + "," + this.changeDateToString(bankOrderLineOrigin.getRelatedToSelectDate());
            pieceDueDateList = pieceDueDateList + "," + this.changeDateToString(bankOrderLineOrigin.getRelatedToSelectDueDate());
        }
        json.put("$pieceReferenceList", StringTool.cutTooLongString((String)pieceReferenceList));
        json.put("$pieceDateList", StringTool.cutTooLongString((String)pieceDateList));
        json.put("$pieceDueDateList", StringTool.cutTooLongString((String)pieceDueDateList));
        return super.populate(json, context);
    }

    protected String changeNullToEmptyString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    protected String changeDateToString(LocalDate date) {
        if (date == null) {
            return "";
        }
        return date.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
    }
}

