/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.db.repo;

import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.repo.BankOrderRepository;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderService;
import com.axelor.db.Model;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import javax.persistence.PersistenceException;

public class BankOrderManagementRepository
extends BankOrderRepository {
    public BankOrder save(BankOrder entity) {
        try {
            BankOrderService bankOrderService = (BankOrderService)Beans.get(BankOrderService.class);
            bankOrderService.generateSequence(entity);
            bankOrderService.setSequenceOnBankOrderLines(entity);
            if (entity.getStatusSelect() == 1) {
                bankOrderService.updateTotalAmounts(entity);
            }
            return (BankOrder)((Object)super.save((Model)((Object)entity)));
        }
        catch (Exception e) {
            throw new PersistenceException(e.getLocalizedMessage());
        }
    }

    public BankOrder copy(BankOrder entity, boolean deep) {
        BankOrder copy = (BankOrder)((Object)super.copy((Model)((Object)entity), deep));
        copy.setStatusSelect(1);
        copy.setGeneratedMetaFile(null);
        copy.setSignedMetaFile(null);
        copy.setConfirmationDateTime(null);
        copy.setFileGenerationDateTime(null);
        copy.setValidationDateTime(null);
        copy.setSendingDateTime(null);
        copy.setBankOrderSeq(null);
        return copy;
    }

    public void remove(BankOrder entity) {
        if (entity.getStatusSelect() == 1 || entity.getStatusSelect() == 6) {
            super.remove((Model)((Object)entity));
            return;
        }
        throw new PersistenceException(I18n.get((String)"Bank orders can only be deleted at draft or canceled status."));
    }
}

