/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.certificate;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;

public class KeyStoreManager {
    private KeyStore keyStore;
    private char[] password;
    private Map<String, X509Certificate> certs;

    public final X509Certificate getCertificate(String alias) throws KeyStoreException {
        X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(alias);
        if (cert == null) {
            throw new IllegalArgumentException("alias " + alias + " not found in the KeyStore");
        }
        return cert;
    }

    public final PrivateKey getPrivateKey(String alias) throws GeneralSecurityException {
        PrivateKey key = (PrivateKey)this.keyStore.getKey(alias, this.password);
        if (key == null) {
            throw new IllegalArgumentException("private key not found for alias " + alias);
        }
        return key;
    }

    public void load(String path, char[] password) throws GeneralSecurityException, IOException {
        this.keyStore = KeyStore.getInstance("PKCS12", "BC");
        this.password = password;
        this.load(path);
    }

    private void load(String path) throws GeneralSecurityException, IOException {
        if (path.equals("")) {
            this.keyStore.load(null, null);
        } else {
            this.keyStore.load(new FileInputStream(path), this.password);
            this.certs = this.read(this.keyStore);
        }
    }

    public X509Certificate read(InputStream input, Provider provider) throws CertificateException, IOException {
        X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X.509", provider).generateCertificate(input);
        if (certificate == null) {
            try (PEMParser reader = new PEMParser((Reader)new InputStreamReader(input));){
                X509CertificateHolder certificateHolder = (X509CertificateHolder)reader.readObject();
                certificate = new JcaX509CertificateConverter().getCertificate(certificateHolder);
            }
        }
        return certificate;
    }

    public RSAPublicKey getPublicKey(InputStream input) throws GeneralSecurityException, IOException {
        X509Certificate cert = this.read(input, this.keyStore.getProvider());
        return (RSAPublicKey)cert.getPublicKey();
    }

    public void setCertificateEntry(String alias, InputStream input) throws GeneralSecurityException, IOException {
        this.keyStore.setCertificateEntry(alias, this.read(input, this.keyStore.getProvider()));
    }

    public void save(OutputStream output) throws GeneralSecurityException, IOException {
        this.keyStore.store(output, this.password);
    }

    public Map<String, X509Certificate> getCertificates() {
        return this.certs;
    }

    public Map<String, X509Certificate> read(KeyStore keyStore) throws KeyStoreException {
        HashMap<String, X509Certificate> certificates = new HashMap<String, X509Certificate>();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String alias = enumeration.nextElement();
            certificates.put(alias, (X509Certificate)keyStore.getCertificate(alias));
        }
        return certificates;
    }
}

