/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.certificate;

import com.axelor.exception.AxelorException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class KeyUtil {
    public static KeyPair makeKeyPair(int keyLen) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(keyLen, new SecureRandom());
        KeyPair keypair = keyGen.generateKeyPair();
        return keypair;
    }

    public static String generatePassword() {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            String pwd = Base64.encodeBase64String((byte[])random.generateSeed(5));
            return pwd.substring(0, pwd.length() - 2);
        }
        catch (NoSuchAlgorithmException e) {
            return "changeit";
        }
    }

    public static byte[] getKeyDigest(RSAPublicKey publicKey) throws AxelorException {
        byte[] digest;
        String exponent = Hex.encodeHexString((byte[])publicKey.getPublicExponent().toByteArray());
        String modulus = Hex.encodeHexString((byte[])KeyUtil.removeFirstByte(publicKey.getModulus().toByteArray()));
        String hash = exponent + " " + modulus;
        if (hash.charAt(0) == '0') {
            hash = hash.substring(1);
        }
        try {
            digest = MessageDigest.getInstance("SHA-256", "BC").digest(hash.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException | GeneralSecurityException e) {
            throw new AxelorException(e.getCause(), 4, e.getMessage());
        }
        return new String(Hex.encodeHex((byte[])digest, (boolean)false)).getBytes();
    }

    private static byte[] removeFirstByte(byte[] byteArray) {
        byte[] b = new byte[byteArray.length - 1];
        System.arraycopy(byteArray, 1, b, 0, b.length);
        return b;
    }
}

