/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.certificate;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class X509Generator {
    private static SimpleDateFormat sdfSerial = new SimpleDateFormat("yyyyMMddHHmmssSSS");

    public X509Certificate generateA005Certificate(KeyPair keypair, String issuer, Date notBefore, Date notAfter, boolean useX509ExtensionsBasicConstraints, boolean useX509ExtensionsSubjectKeyIdentifier, boolean useX509ExtensionsAuthorityKeyIdentifier, boolean useX509ExtensionsExtendedKeyUsage) throws GeneralSecurityException, IOException {
        return this.generate(keypair, issuer, notBefore, notAfter, 1, useX509ExtensionsBasicConstraints, useX509ExtensionsSubjectKeyIdentifier, useX509ExtensionsAuthorityKeyIdentifier, useX509ExtensionsExtendedKeyUsage);
    }

    public X509Certificate generateX002Certificate(KeyPair keypair, String issuer, Date notBefore, Date notAfter, boolean useX509ExtensionsBasicConstraints, boolean useX509ExtensionsSubjectKeyIdentifier, boolean useX509ExtensionsAuthorityKeyIdentifier, boolean useX509ExtensionsExtendedKeyUsage) throws GeneralSecurityException, IOException {
        return this.generate(keypair, issuer, notBefore, notAfter, 2, useX509ExtensionsBasicConstraints, useX509ExtensionsSubjectKeyIdentifier, useX509ExtensionsAuthorityKeyIdentifier, useX509ExtensionsExtendedKeyUsage);
    }

    public X509Certificate generateE002Certificate(KeyPair keypair, String issuer, Date notBefore, Date notAfter, boolean useX509ExtensionsBasicConstraints, boolean useX509ExtensionsSubjectKeyIdentifier, boolean useX509ExtensionsAuthorityKeyIdentifier, boolean useX509ExtensionsExtendedKeyUsage) throws GeneralSecurityException, IOException {
        return this.generate(keypair, issuer, notBefore, notAfter, 3, useX509ExtensionsBasicConstraints, useX509ExtensionsSubjectKeyIdentifier, useX509ExtensionsAuthorityKeyIdentifier, useX509ExtensionsExtendedKeyUsage);
    }

    public X509Certificate generate(KeyPair keypair, String issuer, Date notBefore, Date notAfter, int keyusage, boolean useX509ExtensionsBasicConstraints, boolean useX509ExtensionsSubjectKeyIdentifier, boolean useX509ExtensionsAuthorityKeyIdentifier, boolean useX509ExtensionsExtendedKeyUsage) throws GeneralSecurityException, IOException {
        BigInteger serial = BigInteger.valueOf(this.generateSerial());
        X509V3CertificateGenerator generator = new X509V3CertificateGenerator();
        generator.setSerialNumber(serial);
        generator.setIssuerDN((X509Name)new X509Principal(issuer));
        generator.setNotBefore(notBefore);
        generator.setNotAfter(notAfter);
        generator.setSubjectDN((X509Name)new X509Principal(issuer));
        generator.setPublicKey(keypair.getPublic());
        generator.setSignatureAlgorithm("SHA256WithRSAEncryption");
        if (useX509ExtensionsBasicConstraints) {
            generator.addExtension(X509Extensions.BasicConstraints, false, (ASN1Encodable)new BasicConstraints(true));
        }
        if (useX509ExtensionsSubjectKeyIdentifier) {
            generator.addExtension(X509Extensions.SubjectKeyIdentifier, false, (ASN1Encodable)this.getSubjectKeyIdentifier(keypair.getPublic()));
        }
        if (useX509ExtensionsAuthorityKeyIdentifier) {
            generator.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (ASN1Encodable)this.getAuthorityKeyIdentifier(keypair.getPublic(), issuer, serial));
        }
        if (useX509ExtensionsExtendedKeyUsage) {
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add((ASN1Encodable)KeyPurposeId.id_kp_emailProtection);
            generator.addExtension(X509Extensions.ExtendedKeyUsage, false, (ASN1Encodable)ExtendedKeyUsage.getInstance((Object)new DERSequence(vector)));
        }
        switch (keyusage) {
            case 1: {
                generator.addExtension(X509Extensions.KeyUsage, true, (ASN1Encodable)new KeyUsage(64));
                break;
            }
            case 2: {
                generator.addExtension(X509Extensions.KeyUsage, true, (ASN1Encodable)new KeyUsage(128));
                break;
            }
            case 3: {
                generator.addExtension(X509Extensions.KeyUsage, true, (ASN1Encodable)new KeyUsage(40));
                break;
            }
            default: {
                generator.addExtension(X509Extensions.KeyUsage, false, (ASN1Encodable)new KeyUsage(160));
            }
        }
        X509Certificate certificate = generator.generate(keypair.getPrivate(), "BC", new SecureRandom());
        certificate.checkValidity(new Date());
        certificate.verify(keypair.getPublic());
        return certificate;
    }

    private AuthorityKeyIdentifier getAuthorityKeyIdentifier(PublicKey publicKey, String issuer, BigInteger serial) throws IOException {
        SubjectPublicKeyInfo keyInfo;
        ByteArrayInputStream input = new ByteArrayInputStream(publicKey.getEncoded());
        try (ASN1InputStream is = new ASN1InputStream((InputStream)input);){
            keyInfo = SubjectPublicKeyInfo.getInstance((Object)((ASN1Sequence)is.readObject()));
        }
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)new GeneralName(new X509Name(issuer)));
        return new AuthorityKeyIdentifier(keyInfo, GeneralNames.getInstance((Object)new DERSequence(vector)), serial);
    }

    private SubjectKeyIdentifier getSubjectKeyIdentifier(PublicKey publicKey) throws IOException, NoSuchAlgorithmException {
        SubjectPublicKeyInfo keyInfo;
        ByteArrayInputStream input = new ByteArrayInputStream(publicKey.getEncoded());
        try (ASN1InputStream is = new ASN1InputStream((InputStream)input);){
            keyInfo = SubjectPublicKeyInfo.getInstance((Object)((ASN1Sequence)is.readObject()));
        }
        JcaX509ExtensionUtils jcaX509ExtensionUtils = new JcaX509ExtensionUtils();
        return jcaX509ExtensionUtils.createSubjectKeyIdentifier(keyInfo);
    }

    private long generateSerial() {
        Date now = new Date();
        String sNow = sdfSerial.format(now);
        return Long.valueOf(sNow);
    }

    static {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        sdfSerial.setTimeZone(tz);
    }
}

