/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.client;

import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.ebics.client.EbicsProduct;
import com.axelor.apps.bankpayment.ebics.service.EbicsCertificateService;
import com.axelor.exception.AxelorException;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;

public class EbicsSession {
    private EbicsUser user;
    private EbicsUser signatoryUser;
    private EbicsProduct product;
    private Map<String, String> parameters;

    public EbicsSession(EbicsUser user) {
        this.user = user;
        this.parameters = new HashMap<String, String>();
    }

    public EbicsSession(EbicsUser user, EbicsUser signatoryUser) {
        this.user = user;
        this.signatoryUser = signatoryUser;
        this.parameters = new HashMap<String, String>();
    }

    public RSAPublicKey getBankE002Key() throws AxelorException {
        return (RSAPublicKey)EbicsCertificateService.getBankCertificate(this.user.getEbicsPartner().getEbicsBank(), "encryption").getPublicKey();
    }

    public RSAPublicKey getBankX002Key() throws AxelorException {
        return (RSAPublicKey)EbicsCertificateService.getBankCertificate(this.user.getEbicsPartner().getEbicsBank(), "authentication").getPublicKey();
    }

    public String getBankID() throws AxelorException {
        return this.user.getEbicsPartner().getEbicsBank().getHostId();
    }

    public EbicsUser getUser() {
        return this.user;
    }

    public EbicsUser getSignatoryUser() {
        return this.signatoryUser;
    }

    public void setProduct(EbicsProduct product) {
        this.product = product;
    }

    public EbicsProduct getProduct() {
        return this.product;
    }

    public void addSessionParam(String key, String value) {
        this.parameters.put(key, value);
    }

    public String getSessionParam(String key) {
        if (key == null) {
            return null;
        }
        return this.parameters.get(key);
    }
}

