/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.client;

import com.axelor.app.AppSettings;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.ErrorHandler;

public class EbicsUtils {
    public static byte[] zip(byte[] toZip) throws AxelorException {
        if (toZip == null) {
            throw new AxelorException(1, I18n.get((String)"The input to be zipped cannot be null"));
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream(toZip.length);
        byte[] buffer = new byte[1024];
        Deflater compressor = new Deflater(9);
        compressor.setInput(toZip);
        compressor.finish();
        while (!compressor.finished()) {
            int count = compressor.deflate(buffer);
            output.write(buffer, 0, count);
        }
        try {
            output.close();
        }
        catch (IOException e) {
            throw new AxelorException(e.getCause(), 4, e.getMessage());
        }
        compressor.end();
        return output.toByteArray();
    }

    public static byte[] generateNonce() throws AxelorException {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            return secureRandom.generateSeed(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AxelorException(e.getCause(), 5, e.getMessage());
        }
    }

    public static byte[] unzip(byte[] zip) throws AxelorException {
        Inflater decompressor = new Inflater();
        ByteArrayOutputStream output = new ByteArrayOutputStream(zip.length);
        decompressor.setInput(zip);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            int count;
            try {
                count = decompressor.inflate(buf);
            }
            catch (DataFormatException e) {
                throw new AxelorException(e.getCause(), 5, e.getMessage());
            }
            output.write(buf, 0, count);
        }
        try {
            output.close();
        }
        catch (IOException e) {
            throw new AxelorException(e.getCause(), 5, e.getMessage());
        }
        decompressor.end();
        return output.toByteArray();
    }

    public static byte[] canonize(byte[] input) throws AxelorException {
        try {
            Node node;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
            Document document = builder.parse(new ByteArrayInputStream(input));
            NodeIterator iter = XPathAPI.selectNodeIterator((Node)document, (String)"//*[@authenticate='true']");
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            while ((node = iter.nextNode()) != null) {
                Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
                output.write(canonicalizer.canonicalizeSubtree(node));
            }
            return output.toByteArray();
        }
        catch (Exception e) {
            throw new AxelorException(e.getCause(), 4, e.getMessage());
        }
    }

    public static byte[] encrypt(byte[] input, SecretKeySpec keySpec) throws AxelorException {
        return EbicsUtils.encryptOrDecrypt(1, input, keySpec);
    }

    public static byte[] decrypt(byte[] input, SecretKeySpec keySpec) throws AxelorException {
        return EbicsUtils.encryptOrDecrypt(2, input, keySpec);
    }

    private static byte[] encryptOrDecrypt(int mode, byte[] input, SecretKeySpec keySpec) throws AxelorException {
        IvParameterSpec iv = new IvParameterSpec(new byte[16]);
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/ISO10126Padding", "BC");
            cipher.init(mode, (Key)keySpec, iv);
            return cipher.doFinal(input);
        }
        catch (GeneralSecurityException e) {
            throw new AxelorException(e.getCause(), 4, e.getMessage());
        }
    }

    public static Date parse(String date) throws AxelorException {
        try {
            return new SimpleDateFormat(AppSettings.get().get("date.format")).parse(date);
        }
        catch (Exception e) {
            throw new AxelorException(e.getCause(), 4, e.getMessage());
        }
    }

    public static void checkHttpCode(int httpCode) throws AxelorException {
        if (httpCode != 200) {
            throw new AxelorException(5, "http.code.error[Code:%s]", new Object[]{httpCode});
        }
    }
}

