/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.client;

import com.axelor.apps.bankpayment.db.EbicsTransferState;
import com.axelor.apps.bankpayment.ebics.client.EbicsRootElement;
import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.client.EbicsUtils;
import com.axelor.apps.bankpayment.ebics.client.HttpRequestSender;
import com.axelor.apps.bankpayment.ebics.client.OrderType;
import com.axelor.apps.bankpayment.ebics.interfaces.ContentFactory;
import com.axelor.apps.bankpayment.ebics.io.ByteArrayContentFactory;
import com.axelor.apps.bankpayment.ebics.io.Joiner;
import com.axelor.apps.bankpayment.ebics.xml.DInitializationRequestElement;
import com.axelor.apps.bankpayment.ebics.xml.DInitializationResponseElement;
import com.axelor.apps.bankpayment.ebics.xml.DTransferRequestElement;
import com.axelor.apps.bankpayment.ebics.xml.DTransferResponseElement;
import com.axelor.apps.bankpayment.ebics.xml.DefaultEbicsRootElement;
import com.axelor.apps.bankpayment.ebics.xml.InitializationResponseElement;
import com.axelor.apps.bankpayment.ebics.xml.ReceiptRequestElement;
import com.axelor.apps.bankpayment.ebics.xml.ReceiptResponseElement;
import com.axelor.apps.bankpayment.ebics.xml.TransferResponseElement;
import com.axelor.apps.bankpayment.ebics.xml.UInitializationRequestElement;
import com.axelor.apps.bankpayment.ebics.xml.UTransferRequestElement;
import com.axelor.exception.AxelorException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.jdom.JDOMException;

public class FileTransfer {
    private EbicsSession session;

    public FileTransfer(EbicsSession session) {
        this.session = session;
    }

    public void sendFile(byte[] content, OrderType orderType, byte[] signature) throws IOException, AxelorException {
        HttpRequestSender sender = new HttpRequestSender(this.session);
        UInitializationRequestElement initializer = new UInitializationRequestElement(this.session, orderType, content, signature);
        initializer.build();
        initializer.validate();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            initializer.save(bout);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        System.out.println("Requete ----------------------------------------------------------------------------");
        System.out.println(bout.toString());
        int httpCode = sender.send(new ByteArrayContentFactory(initializer.prettyPrint()));
        EbicsUtils.checkHttpCode(httpCode);
        InitializationResponseElement response = new InitializationResponseElement(sender.getResponseBody(), orderType, DefaultEbicsRootElement.generateName(orderType), this.session.getUser());
        response.build();
        response.report(new EbicsRootElement[]{initializer, response});
        EbicsTransferState state = new EbicsTransferState();
        state.setNumSegments(initializer.getSegmentNumber());
        state.setTransactionId(response.getTransactionId());
        for (int segNumber = 1; segNumber <= state.getNumSegments(); ++segNumber) {
            state.setSegmentNumber(segNumber);
            if (segNumber == state.getSegmentNumber()) {
                state.setLastSegment(true);
            }
            this.sendFile(initializer.getContent(segNumber), segNumber, state.getLastSegment(), state.getTransactionId(), orderType);
        }
    }

    public void sendFile(ContentFactory factory, int segmentNumber, boolean lastSegment, byte[] transactionId, OrderType orderType) throws IOException, AxelorException {
        UTransferRequestElement uploader = new UTransferRequestElement(this.session, orderType, segmentNumber, lastSegment, transactionId, factory);
        HttpRequestSender sender = new HttpRequestSender(this.session);
        uploader.build();
        uploader.validate();
        int httpCode = sender.send(new ByteArrayContentFactory(uploader.prettyPrint()));
        EbicsUtils.checkHttpCode(httpCode);
        TransferResponseElement response = new TransferResponseElement(sender.getResponseBody(), DefaultEbicsRootElement.generateName(orderType), this.session.getUser());
        response.build();
        response.report(new EbicsRootElement[]{uploader, response});
    }

    public void fetchFile(OrderType orderType, Date start, Date end, OutputStream dest) throws IOException, AxelorException {
        HttpRequestSender sender = new HttpRequestSender(this.session);
        DInitializationRequestElement initializer = new DInitializationRequestElement(this.session, orderType, start, end);
        initializer.build();
        initializer.validate();
        int httpCode = sender.send(new ByteArrayContentFactory(initializer.prettyPrint()));
        EbicsUtils.checkHttpCode(httpCode);
        DInitializationResponseElement response = new DInitializationResponseElement(sender.getResponseBody(), orderType, DefaultEbicsRootElement.generateName(orderType), this.session.getUser());
        response.build();
        response.report(new EbicsRootElement[]{initializer, response});
        EbicsTransferState state = new EbicsTransferState();
        state.setSegmentNumber(response.getSegmentsNumber());
        state.setTransactionId(response.getTransactionId());
        state.setSegmentNumber(response.getSegmentNumber());
        Joiner joiner = new Joiner(this.session.getUser());
        joiner.append(response.getOrderData());
        while (state.getSegmentNumber() <= state.getNumSegments()) {
            if (state.getSegmentNumber() == state.getNumSegments()) {
                state.setLastSegment(true);
            }
            this.fetchFile(orderType, state.getSegmentNumber(), state.getLastSegment(), state.getTransactionId(), joiner);
            state.setSegmentNumber(state.getSegmentNumber() + 1);
        }
        joiner.writeTo(dest, response.getTransactionKey());
        ReceiptRequestElement receipt = new ReceiptRequestElement(this.session, state.getTransactionId(), DefaultEbicsRootElement.generateName(orderType));
        receipt.build();
        receipt.validate();
        httpCode = sender.send(new ByteArrayContentFactory(receipt.prettyPrint()));
        EbicsUtils.checkHttpCode(httpCode);
        ReceiptResponseElement receiptResponse = new ReceiptResponseElement(sender.getResponseBody(), DefaultEbicsRootElement.generateName(orderType), this.session.getUser());
        receiptResponse.build();
        receiptResponse.report(new EbicsRootElement[]{receipt, receiptResponse});
    }

    public void fetchFile(OrderType orderType, int segmentNumber, boolean lastSegment, byte[] transactionId, Joiner joiner) throws IOException, AxelorException {
        HttpRequestSender sender = new HttpRequestSender(this.session);
        DTransferRequestElement downloader = new DTransferRequestElement(this.session, orderType, segmentNumber, lastSegment, transactionId);
        downloader.build();
        downloader.validate();
        int httpCode = sender.send(new ByteArrayContentFactory(downloader.prettyPrint()));
        EbicsUtils.checkHttpCode(httpCode);
        DTransferResponseElement response = new DTransferResponseElement(sender.getResponseBody(), orderType, DefaultEbicsRootElement.generateName(orderType), this.session.getUser());
        response.build();
        response.report(new EbicsRootElement[]{downloader, response});
        joiner.append(response.getOrderData());
    }
}

