/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.client;

import com.axelor.app.AppSettings;
import com.axelor.apps.bankpayment.db.EbicsBank;
import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.client.InputStreamContentFactory;
import com.axelor.apps.bankpayment.ebics.interfaces.ContentFactory;
import com.axelor.apps.bankpayment.ebics.service.EbicsCertificateService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.http.HttpEntity;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestSender {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private EbicsSession session;
    private ContentFactory response;

    public HttpRequestSender(EbicsSession session) {
        this.session = session;
    }

    public final int send(ContentFactory request) throws IOException, AxelorException {
        EbicsBank bank = this.session.getUser().getEbicsPartner().getEbicsBank();
        String url = bank.getUrl();
        if (url == null || !url.startsWith("http://") && !url.startsWith("https://")) {
            throw new AxelorException(1, I18n.get((String)"Invalid bank url. It must be start with http:// or https://"));
        }
        if (bank.getProtocolSelect().equals("ssl")) {
            return this.sendSSL(request, bank);
        }
        return this.sendTLS(request, bank);
    }

    public final int sendSSL(ContentFactory request, EbicsBank bank) throws AxelorException, IOException {
        String url = bank.getUrl();
        X509Certificate certificate = EbicsCertificateService.getBankCertificate(bank, "ssl");
        DefaultHttpClient client = this.getSecuredHttpClient(certificate, url);
        String proxyConfiguration = AppSettings.get().get("http.proxy.host");
        if (proxyConfiguration != null && !proxyConfiguration.equals("")) {
            this.setProxy(client);
        }
        InputStream input = request.getContent();
        int retCode = -1;
        this.log.debug("Bank url: {}", (Object)url);
        HttpPost post = new HttpPost(url);
        ContentType type = ContentType.TEXT_XML;
        InputStreamEntity entity = new InputStreamEntity(input, (long)retCode, type);
        post.setEntity((HttpEntity)entity);
        try {
            CloseableHttpResponse responseHttp = client.execute((HttpUriRequest)post);
            retCode = responseHttp.getStatusLine().getStatusCode();
            this.log.debug("Http reason phrase: {}", (Object)responseHttp.getStatusLine().getReasonPhrase());
            this.response = new InputStreamContentFactory(responseHttp.getEntity().getContent());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new AxelorException(e.getCause(), 1, I18n.get((String)"Connection error: %s"), new Object[]{e.getMessage()});
        }
        return retCode;
    }

    public final int sendTLS(ContentFactory request, EbicsBank bank) throws IOException {
        HttpClient httpClient = new HttpClient();
        String proxyConfiguration = AppSettings.get().get("http.proxy.host");
        if (proxyConfiguration != null && !proxyConfiguration.equals("")) {
            this.setProxy(httpClient);
        }
        InputStream input = request.getContent();
        PostMethod method = new PostMethod(bank.getUrl());
        method.getParams().setSoTimeout(30000);
        InputStreamRequestEntity requestEntity = new InputStreamRequestEntity(input);
        method.setRequestEntity((RequestEntity)requestEntity);
        method.setRequestHeader("Content-type", "text/xml; charset=ISO-8859-1");
        int retCode = -1;
        retCode = httpClient.executeMethod((HttpMethod)method);
        this.response = new InputStreamContentFactory(method.getResponseBodyAsStream());
        return retCode;
    }

    private void setProxy(DefaultHttpClient client) {
        String proxyHost = AppSettings.get().get("http.proxy.host").trim();
        int proxyPort = Integer.parseInt(AppSettings.get().get("http.proxy.port").trim());
        if (!AppSettings.get().get("http.proxy.user").equals("")) {
            String user = AppSettings.get().get("http.proxy.user").trim();
            String pwd = AppSettings.get().get("http.proxy.password").trim();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(user, pwd);
            org.apache.http.auth.AuthScope authscope = new org.apache.http.auth.AuthScope(proxyHost, proxyPort);
            client.getCredentialsProvider().setCredentials(authscope, (org.apache.http.auth.Credentials)credentials);
        }
    }

    private void setProxy(HttpClient httpClient) {
        String proxyHost = AppSettings.get().get("http.proxy.host").trim();
        Integer proxyPort = Integer.parseInt(AppSettings.get().get("http.proxy.port").trim());
        HostConfiguration hostConfig = httpClient.getHostConfiguration();
        hostConfig.setProxy(proxyHost, proxyPort.intValue());
        if (!AppSettings.get().get("http.proxy.user").equals("")) {
            String user = AppSettings.get().get("http.proxy.user").trim();
            String pwd = AppSettings.get().get("http.proxy.password").trim();
            org.apache.commons.httpclient.UsernamePasswordCredentials credentials = new org.apache.commons.httpclient.UsernamePasswordCredentials(user, pwd);
            AuthScope authscope = new AuthScope(proxyHost, proxyPort.intValue());
            httpClient.getState().setProxyCredentials(authscope, (Credentials)credentials);
        }
    }

    private DefaultHttpClient getSecuredHttpClient(Certificate cert, String bankURL) throws AxelorException {
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)30000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)30000);
        DefaultHttpClient client = new DefaultHttpClient((HttpParams)httpParams);
        try {
            Scheme https = null;
            if (cert != null) {
                this.log.debug("SSL certificate exist");
                URL url = new URL(bankURL);
                this.log.debug("Url host: {}", (Object)url.getHost());
                KeyStore keystore = KeyStore.getInstance("jks");
                char[] password = "NoPassword".toCharArray();
                keystore.load(null, password);
                keystore.setCertificateEntry(url.getHost(), cert);
                SSLSocketFactory factory = new SSLSocketFactory(keystore);
                try {
                    factory.getHostnameVerifier().verify(url.getHost(), (X509Certificate)cert);
                    https = new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory(keystore));
                }
                catch (SSLException e) {
                    this.log.debug("Error in ssl certifcate host name verification");
                    https = new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory());
                }
            } else {
                this.log.debug("SSL certificate not exist");
                https = new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory());
            }
            client.getConnectionManager().getSchemeRegistry().register(https);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AxelorException(e.getCause(), 4, I18n.get((String)"Error adding certificate"));
        }
        return client;
    }

    public ContentFactory getResponseBody() {
        return this.response;
    }
}

