/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.client;

import com.axelor.apps.bankpayment.ebics.certificate.KeyStoreManager;
import com.axelor.apps.bankpayment.ebics.client.EbicsRootElement;
import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.client.EbicsUtils;
import com.axelor.apps.bankpayment.ebics.client.HttpRequestSender;
import com.axelor.apps.bankpayment.ebics.io.ByteArrayContentFactory;
import com.axelor.apps.bankpayment.ebics.service.EbicsUserService;
import com.axelor.apps.bankpayment.ebics.xml.HIARequestElement;
import com.axelor.apps.bankpayment.ebics.xml.HPBRequestElement;
import com.axelor.apps.bankpayment.ebics.xml.HPBResponseOrderDataElement;
import com.axelor.apps.bankpayment.ebics.xml.INIRequestElement;
import com.axelor.apps.bankpayment.ebics.xml.KeyManagementResponseElement;
import com.axelor.apps.bankpayment.ebics.xml.SPRRequestElement;
import com.axelor.apps.bankpayment.ebics.xml.SPRResponseElement;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import org.jdom.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyManagement {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private EbicsSession session;

    public KeyManagement(EbicsSession session) {
        this.session = session;
    }

    public void sendINI() throws IOException, AxelorException, JDOMException {
        HttpRequestSender sender = new HttpRequestSender(this.session);
        this.log.debug("HttpRequestSender OK");
        INIRequestElement request = new INIRequestElement(this.session);
        this.log.debug("INIRequestElement OK");
        request.build();
        this.log.debug("build OK");
        request.validate();
        this.log.debug("validate OK");
        int httpCode = sender.send(new ByteArrayContentFactory(request.prettyPrint()));
        this.log.debug("send OK");
        EbicsUtils.checkHttpCode(httpCode);
        this.log.debug("checkHttpCode OK");
        KeyManagementResponseElement response = new KeyManagementResponseElement(sender.getResponseBody(), "INIResponse", this.session.getUser());
        this.log.debug("KeyManagementResponseElement OK");
        response.build();
        this.log.debug("build OK");
        response.report(new EbicsRootElement[]{request, response});
        this.log.debug("report OK");
    }

    public void sendHIA() throws IOException, AxelorException, JDOMException {
        HttpRequestSender sender = new HttpRequestSender(this.session);
        HIARequestElement request = new HIARequestElement(this.session);
        request.build();
        request.validate();
        int httpCode = sender.send(new ByteArrayContentFactory(request.prettyPrint()));
        EbicsUtils.checkHttpCode(httpCode);
        KeyManagementResponseElement response = new KeyManagementResponseElement(sender.getResponseBody(), "HIAResponse", this.session.getUser());
        response.build();
        response.report(new EbicsRootElement[]{request, response});
    }

    public X509Certificate[] sendHPB() throws IOException, GeneralSecurityException, AxelorException, JDOMException {
        HttpRequestSender sender = new HttpRequestSender(this.session);
        HPBRequestElement request = new HPBRequestElement(this.session);
        request.build();
        request.validate();
        int httpCode = sender.send(new ByteArrayContentFactory(request.prettyPrint()));
        EbicsUtils.checkHttpCode(httpCode);
        KeyManagementResponseElement response = new KeyManagementResponseElement(sender.getResponseBody(), "HBPResponse", this.session.getUser());
        response.build();
        response.report(new EbicsRootElement[]{request, response});
        EbicsUserService userService = (EbicsUserService)Beans.get(EbicsUserService.class);
        ByteArrayContentFactory factory = new ByteArrayContentFactory(EbicsUtils.unzip(userService.decrypt(this.session.getUser(), response.getOrderData(), response.getTransactionKey())));
        HPBResponseOrderDataElement orderData = new HPBResponseOrderDataElement(factory, this.session.getUser());
        orderData.build();
        return this.createCertificates(orderData);
    }

    private X509Certificate[] createCertificates(HPBResponseOrderDataElement orderData) throws AxelorException, GeneralSecurityException, IOException {
        KeyStoreManager keystoreManager = new KeyStoreManager();
        if (this.session.getUser().getPassword() != null) {
            keystoreManager.load("", this.session.getUser().getPassword().toCharArray());
        } else {
            keystoreManager.load("", null);
        }
        String certId = this.session.getBankID() + "-E002";
        keystoreManager.setCertificateEntry(certId, new ByteArrayInputStream(orderData.getBankE002Certificate()));
        X509Certificate certificateE002 = keystoreManager.getCertificate(certId);
        certId = this.session.getBankID() + "-X002";
        keystoreManager.setCertificateEntry(certId, new ByteArrayInputStream(orderData.getBankX002Certificate()));
        X509Certificate certificateX002 = keystoreManager.getCertificate(certId);
        return new X509Certificate[]{certificateE002, certificateX002};
    }

    public void lockAccess() throws IOException, AxelorException, JDOMException {
        HttpRequestSender sender = new HttpRequestSender(this.session);
        SPRRequestElement request = new SPRRequestElement(this.session);
        request.build();
        request.validate();
        int httpCode = sender.send(new ByteArrayContentFactory(request.prettyPrint()));
        EbicsUtils.checkHttpCode(httpCode);
        SPRResponseElement response = new SPRResponseElement(sender.getResponseBody(), this.session.getUser());
        response.build();
        response.report(new EbicsRootElement[]{request, response});
    }
}

