/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.client;

import com.axelor.apps.bankpayment.ebics.client.OrderType;

public class OrderAttribute {
    private char transmittedDataType;
    public static final char TRANSMITTED_DATA_TYPE_O = 'O';
    public static final char TRANSMITTED_DATA_TYPE_U = 'U';
    public static final char TRANSMITTED_DATA_TYPE_D = 'D';
    private char compressionType;
    public static final char COMPRESSION_TYPE_Z = 'Z';
    private char encryptionType;
    public static final char ENCRYPTION_TYPE_N = 'N';
    public static final char ENCRYPTION_TYPE_H = 'H';
    public static final char RESERVED_POSITION = 'N';
    private String orderAttributes;

    public char computeTransmittedDataType(OrderType orderType, int ebicsTypeSelect) {
        if (orderType.equals(OrderType.INI)) {
            return 'D';
        }
        if (orderType.equals(OrderType.HIA)) {
            return 'D';
        }
        if (orderType.equals(OrderType.HPB)) {
            return 'D';
        }
        if (orderType.equals(OrderType.FUL)) {
            if (ebicsTypeSelect == 0) {
                return 'D';
            }
            if (ebicsTypeSelect == 1) {
                return 'O';
            }
        } else {
            if (orderType.equals(OrderType.FDL) || orderType.equals(OrderType.HTD) || orderType.equals(OrderType.HPD) || orderType.equals(OrderType.PTK)) {
                return 'D';
            }
            if (orderType.equals(OrderType.SPR)) {
                return 'U';
            }
        }
        throw new IllegalArgumentException("NOT SUPPORTED ORDER TYPE OR EBICS MODE");
    }

    public char computeCompressionType() {
        return 'Z';
    }

    public char computeEncryptionType(OrderType orderType) {
        if (orderType.equals(OrderType.INI)) {
            return 'N';
        }
        if (orderType.equals(OrderType.HIA)) {
            return 'N';
        }
        if (orderType.equals(OrderType.HPB)) {
            return 'H';
        }
        if (orderType.equals(OrderType.FUL)) {
            return 'H';
        }
        if (orderType.equals(OrderType.FDL) || orderType.equals(OrderType.HTD) || orderType.equals(OrderType.HPD) || orderType.equals(OrderType.PTK)) {
            return 'H';
        }
        if (orderType.equals(OrderType.SPR)) {
            return 'H';
        }
        throw new IllegalArgumentException("NOT SUPPORTED ORDER TYPE OR EBICS MODE");
    }

    public OrderAttribute(OrderType orderType, int ebicsTypeSelect) {
        this.transmittedDataType = this.computeTransmittedDataType(orderType, ebicsTypeSelect);
        this.compressionType = this.computeCompressionType();
        this.encryptionType = this.computeEncryptionType(orderType);
    }

    public OrderAttribute(char transmittedDataType, char compressionType, char encryptionType) {
        this.transmittedDataType = transmittedDataType;
        this.compressionType = compressionType;
        this.encryptionType = encryptionType;
    }

    public OrderAttribute build() {
        this.orderAttributes = "" + this.transmittedDataType + this.compressionType + this.encryptionType + 'N' + 'N';
        return this;
    }

    public String getOrderAttributes() {
        return this.orderAttributes;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OrderAttribute) {
            return this.orderAttributes.equals(((OrderAttribute)obj).getOrderAttributes());
        }
        return false;
    }
}

