/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.client;

import com.axelor.apps.account.ebics.schema.h003.EbicsUnsecuredRequestDocument;
import com.axelor.apps.account.ebics.schema.h003.EmptyMutableHeaderType;
import com.axelor.apps.account.ebics.schema.h003.OrderDetailsType;
import com.axelor.apps.account.ebics.schema.h003.ProductElementType;
import com.axelor.apps.account.ebics.schema.h003.UnsecuredRequestStaticHeaderType;
import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.client.OrderType;
import com.axelor.apps.bankpayment.ebics.xml.DefaultEbicsRootElement;
import com.axelor.apps.bankpayment.ebics.xml.EbicsXmlFactory;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.exception.AxelorException;
import java.util.Optional;

public class UnsecuredRequestElement
extends DefaultEbicsRootElement {
    private OrderType orderType;
    private byte[] orderData;

    public UnsecuredRequestElement(EbicsSession session, OrderType orderType, byte[] orderData) {
        super(session);
        this.orderType = orderType;
        this.orderData = orderData;
    }

    @Override
    public void build() throws AxelorException {
        OrderDetailsType orderDetails = EbicsXmlFactory.createOrderDetailsType("DZNNN", this.session.getUser().getNextOrderId(), this.orderType.getOrderType());
        ProductElementType productType = EbicsXmlFactory.creatProductElementType(Optional.ofNullable(AuthUtils.getUser()).map(User::getLanguage).orElse(null), this.session.getProduct().getName());
        try {
            UnsecuredRequestStaticHeaderType xstatic = EbicsXmlFactory.createUnsecuredRequestStaticHeaderType(this.session.getBankID(), this.session.getUser().getEbicsPartner().getPartnerId(), this.session.getUser().getUserId(), productType, orderDetails, this.session.getUser().getSecurityMedium());
            EmptyMutableHeaderType mutable = EbicsXmlFactory.createEmptyMutableHeaderType();
            EbicsUnsecuredRequestDocument.EbicsUnsecuredRequest.Header header = EbicsXmlFactory.createHeader(true, mutable, xstatic);
            EbicsUnsecuredRequestDocument.EbicsUnsecuredRequest.Body.DataTransfer.OrderData orderData = EbicsXmlFactory.createOrderData(this.orderData);
            EbicsUnsecuredRequestDocument.EbicsUnsecuredRequest.Body.DataTransfer dataTransfer = EbicsXmlFactory.createDataTransfer(orderData);
            EbicsUnsecuredRequestDocument.EbicsUnsecuredRequest.Body body = EbicsXmlFactory.createBody(dataTransfer);
            EbicsUnsecuredRequestDocument.EbicsUnsecuredRequest request = EbicsXmlFactory.createEbicsUnsecuredRequest(header, body, 1, "H003");
            this.document = EbicsXmlFactory.createEbicsUnsecuredRequestDocument(request);
        }
        catch (AxelorException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return "UnsecuredRequest.xml";
    }
}

