/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.io;

import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.ebics.client.EbicsUtils;
import com.axelor.apps.bankpayment.ebics.service.EbicsUserService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;

public class Joiner {
    private EbicsUser user;
    private ByteArrayOutputStream buffer;

    public Joiner(EbicsUser user) {
        this.user = user;
        this.buffer = new ByteArrayOutputStream();
    }

    public void append(byte[] data) throws AxelorException {
        try {
            this.buffer.write(data);
            this.buffer.flush();
        }
        catch (IOException e) {
            throw new AxelorException(e.getCause(), 4, e.getMessage());
        }
    }

    public void writeTo(OutputStream output, byte[] transactionKey) throws AxelorException {
        try {
            this.buffer.close();
            byte[] decrypted = ((EbicsUserService)Beans.get(EbicsUserService.class)).decrypt(this.user, this.buffer.toByteArray(), transactionKey);
            output.write(EbicsUtils.unzip(decrypted));
            output.close();
        }
        catch (GeneralSecurityException e) {
            throw new AxelorException(e.getCause(), 5, e.getMessage());
        }
        catch (IOException e) {
            throw new AxelorException(e.getCause(), 4, e.getMessage());
        }
    }
}

