/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.service;

import com.axelor.apps.bankpayment.db.EbicsBank;
import com.axelor.apps.bankpayment.db.EbicsCertificate;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.db.repo.EbicsCertificateRepository;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.tool.date.DateTool;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaStore;
import com.axelor.meta.schema.views.Selection;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EbicsCertificateService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    private EbicsCertificateRepository certRepo;
    @Inject
    private AppBaseService appBaseService;

    public static byte[] getCertificateContent(EbicsBank bank, String type) throws AxelorException {
        EbicsCertificate cert = EbicsCertificateService.getEbicsCertificate(bank, type);
        if (cert != null) {
            return cert.getCertificate();
        }
        if (bank.getUrl() != null && type.equals("ssl")) {
            return ((EbicsCertificateService)Beans.get(EbicsCertificateService.class)).getSSLCertificate(bank);
        }
        throw new AxelorException((Model)((Object)bank), 4, I18n.get((String)"No bank certificate of type %s found"), new Object[]{type});
    }

    public static X509Certificate getCertificate(byte[] certificate, String type) throws AxelorException {
        X509Certificate cert;
        ByteArrayInputStream instream = new ByteArrayInputStream(certificate);
        try {
            cert = (X509Certificate)CertificateFactory.getInstance("X.509", "BC").generateCertificate(instream);
        }
        catch (NoSuchProviderException | CertificateException e) {
            throw new AxelorException(e.getCause(), 4, I18n.get((String)"Error in bank certificate of type %s"), new Object[]{type});
        }
        return cert;
    }

    public static X509Certificate getBankCertificate(EbicsBank bank, String type) throws AxelorException {
        byte[] certificate = EbicsCertificateService.getCertificateContent(bank, type);
        if (certificate == null) {
            return null;
        }
        return EbicsCertificateService.getCertificate(certificate, type);
    }

    private byte[] getSSLCertificate(EbicsBank bank) throws AxelorException {
        try {
            URL bankUrl = new URL(bank.getUrl());
            this.log.debug("Bank url protocol: {}", (Object)bankUrl.getProtocol());
            this.log.debug("Bank url host: {}", (Object)bankUrl.getHost());
            this.log.debug("Bank url port: {}", (Object)bankUrl.getPort());
            String urlStr = bankUrl.getProtocol() + "://" + bankUrl.getHost();
            if (bankUrl.getPort() > -1) {
                urlStr = urlStr + ":" + bankUrl.getPort();
            }
            URL url = new URL(urlStr);
            SSLContext sslCtx = SSLContext.getInstance("TLS");
            sslCtx.init(null, new TrustManager[]{new X509TrustManager(){
                private X509Certificate[] accepted;

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                    this.accepted = arg0;
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return this.accepted;
                }
            }}, null);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
            connection.setSSLSocketFactory(sslCtx.getSocketFactory());
            this.log.debug("SSL connection response code: {}", (Object)connection.getResponseCode());
            this.log.debug("SSL connection response message: {}", (Object)connection.getResponseMessage());
            if (connection.getResponseCode() == 200) {
                Certificate[] certificates = connection.getServerCertificates();
                for (int i = 0; i < certificates.length; ++i) {
                    Certificate certificate = certificates[i];
                    if (!(certificate instanceof X509Certificate)) continue;
                    X509Certificate cert = (X509Certificate)certificate;
                    this.createCertificate(cert, bank, "ssl");
                    return certificate.getEncoded();
                }
            }
            connection.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public EbicsCertificate updateCertificate(X509Certificate certificate, EbicsCertificate cert, boolean cleanPrivateKey) throws CertificateEncodingException, IOException {
        String sha = DigestUtils.sha256Hex((byte[])certificate.getEncoded());
        this.log.debug("sha256 HEX : {}", (Object)sha);
        this.log.debug("certificat : {}", (Object)new String(certificate.getEncoded()));
        this.log.debug("certificat size : {}", (Object)certificate.getEncoded().length);
        cert.setValidFrom(DateTool.toLocalDate((Date)certificate.getNotBefore()));
        cert.setValidTo(DateTool.toLocalDate((Date)certificate.getNotAfter()));
        cert.setIssuer(certificate.getIssuerDN().getName());
        cert.setSubject(certificate.getSubjectDN().getName());
        cert.setCertificate(certificate.getEncoded());
        RSAPublicKey publicKey = (RSAPublicKey)certificate.getPublicKey();
        cert.setPublicKeyExponent(publicKey.getPublicExponent().toString(16));
        cert.setPublicKeyModulus(publicKey.getModulus().toString(16));
        cert.setSerial(certificate.getSerialNumber().toString(16));
        cert.setPemString(this.convertToPEMString(certificate));
        if (cleanPrivateKey) {
            cert.setPrivateKey(null);
        }
        sha = sha.toUpperCase();
        cert.setSha2has(sha);
        this.computeFullName(cert);
        return cert;
    }

    @Transactional
    public EbicsCertificate createCertificate(X509Certificate certificate, EbicsBank bank, String type) throws CertificateEncodingException, IOException {
        EbicsCertificate cert = EbicsCertificateService.getEbicsCertificate(bank, type);
        if (cert == null) {
            this.log.debug("Creating bank certicate for bank: {}, type: {}", (Object)bank.getName(), (Object)type);
            cert = new EbicsCertificate();
            cert.setEbicsBank(bank);
            cert.setTypeSelect(type);
        }
        cert = this.updateCertificate(certificate, cert, true);
        return (EbicsCertificate)((Object)this.certRepo.save((Model)((Object)cert)));
    }

    private static EbicsCertificate getEbicsCertificate(EbicsBank bank, String type) {
        if (bank == null) {
            return null;
        }
        for (EbicsCertificate cert : bank.getEbicsCertificateList()) {
            if (!cert.getTypeSelect().equals(type)) continue;
            return cert;
        }
        return null;
    }

    public void computeFullName(EbicsCertificate entity) {
        String issuer;
        LocalDate date;
        StringBuilder fullName = new StringBuilder();
        Selection.Option item = MetaStore.getSelectionItem((String)"bankpayment.ebics.certificate.type.select", (String)entity.getTypeSelect());
        if (item != null) {
            fullName.append(I18n.get((String)item.getTitle()));
        }
        if ((date = entity.getValidFrom()) != null) {
            fullName.append(":" + date.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
            date = entity.getValidTo();
            if (date != null) {
                fullName.append("-" + date.format(DateTimeFormatter.ofPattern("dd/MM/yyyy")));
            }
        }
        if ((issuer = entity.getIssuer()) != null) {
            fullName.append(":" + issuer);
        }
        entity.setFullName(fullName.toString());
    }

    public String convertToPEMString(X509Certificate x509Cert) throws IOException {
        StringWriter sw = new StringWriter();
        try (PEMWriter pw = new PEMWriter((Writer)sw);){
            pw.writeObject((Object)x509Cert);
        }
        return sw.toString();
    }

    public X509Certificate convertToCertificate(String pemString) throws IOException, CertificateException {
        X509Certificate certificate;
        StringReader reader = new StringReader(pemString);
        try (PEMParser pr = new PEMParser((Reader)reader);){
            X509CertificateHolder certificateHolder = (X509CertificateHolder)pr.readObject();
            certificate = new JcaX509CertificateConverter().getCertificate(certificateHolder);
        }
        return certificate;
    }

    public byte[] convertToDER(String pemString) throws IOException, CertificateException {
        X509Certificate cert = this.convertToCertificate(pemString);
        return cert.getEncoded();
    }

    @Transactional
    public void updateEditionDate(EbicsUser user) {
        LocalDateTime now = this.appBaseService.getTodayDateTime().toLocalDateTime();
        EbicsCertificate certificate = user.getA005Certificate();
        if (certificate != null) {
            certificate.setInitLetterEditionDate(now);
            this.certRepo.save((Model)((Object)certificate));
        }
        if ((certificate = user.getE002Certificate()) != null) {
            certificate.setInitLetterEditionDate(now);
            this.certRepo.save((Model)((Object)certificate));
        }
        if ((certificate = user.getX002Certificate()) != null) {
            certificate.setInitLetterEditionDate(now);
            this.certRepo.save((Model)((Object)certificate));
        }
    }
}

