/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.service;

import com.axelor.apps.bankpayment.db.BankStatement;
import com.axelor.apps.bankpayment.db.BankStatementFileFormat;
import com.axelor.apps.bankpayment.db.EbicsPartner;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.db.repo.BankStatementRepository;
import com.axelor.apps.bankpayment.db.repo.EbicsPartnerRepository;
import com.axelor.apps.bankpayment.ebics.service.EbicsPartnerService;
import com.axelor.apps.bankpayment.ebics.service.EbicsService;
import com.axelor.apps.bankpayment.service.bankstatement.BankStatementCreateService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.tool.date.DateTool;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class EbicsPartnerServiceImpl
implements EbicsPartnerService {
    protected BankStatementCreateService bankStatementCreateService;
    protected EbicsService ebicsService;
    protected BankStatementRepository bankStatementRepository;

    @Inject
    public EbicsPartnerServiceImpl(BankStatementCreateService bankStatementCreateService, EbicsService ebicsService, BankStatementRepository bankStatementRepository) {
        this.bankStatementCreateService = bankStatementCreateService;
        this.ebicsService = ebicsService;
        this.bankStatementRepository = bankStatementRepository;
    }

    @Override
    @Transactional
    public List<BankStatement> getBankStatements(EbicsPartner ebicsPartner) throws AxelorException, IOException {
        return this.getBankStatements(ebicsPartner, null);
    }

    @Override
    @Transactional
    public List<BankStatement> getBankStatements(EbicsPartner ebicsPartner, Collection<BankStatementFileFormat> bankStatementFileFormatCollection) throws AxelorException, IOException {
        ArrayList bankStatementList = Lists.newArrayList();
        EbicsUser transportEbicsUser = ebicsPartner.getTransportEbicsUser();
        if (ebicsPartner.getBsEbicsPartnerServiceList() == null || ebicsPartner.getBsEbicsPartnerServiceList().isEmpty() || transportEbicsUser == null) {
            return bankStatementList;
        }
        LocalDateTime executionDateTime = LocalDateTime.now();
        Date startDate = null;
        Date endDate = null;
        LocalDate bankStatementStartDate = null;
        LocalDate bankStatementToDate = null;
        if (ebicsPartner.getBankStatementGetModeSelect() == 2) {
            bankStatementStartDate = ebicsPartner.getBankStatementStartDate();
            if (bankStatementStartDate != null) {
                startDate = DateTool.toDate((LocalDate)bankStatementStartDate);
            }
            if ((bankStatementToDate = ebicsPartner.getBankStatementEndDate()) != null) {
                endDate = DateTool.toDate((LocalDate)bankStatementToDate);
            }
        } else {
            if (ebicsPartner.getBankStatementLastExeDateT() != null) {
                bankStatementStartDate = ebicsPartner.getBankStatementLastExeDateT().toLocalDate();
            }
            bankStatementToDate = executionDateTime.toLocalDate();
        }
        for (com.axelor.apps.bankpayment.db.EbicsPartnerService bsEbicsPartnerService : ebicsPartner.getBsEbicsPartnerServiceList()) {
            BankStatementFileFormat bankStatementFileFormat = bsEbicsPartnerService.getBankStatementFileFormat();
            if (bankStatementFileFormatCollection != null && !bankStatementFileFormatCollection.isEmpty() && !bankStatementFileFormatCollection.contains((Object)bankStatementFileFormat)) continue;
            try {
                File file = this.ebicsService.sendFDLRequest(transportEbicsUser, null, startDate, endDate, bsEbicsPartnerService.getEbicsCodification());
                BankStatement bankStatement = this.bankStatementCreateService.createBankStatement(file, bankStatementStartDate, bankStatementToDate, bankStatementFileFormat, ebicsPartner, executionDateTime);
                this.bankStatementRepository.save((Model)((Object)bankStatement));
                bankStatementList.add(bankStatement);
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)e);
            }
        }
        ebicsPartner.setBankStatementLastExeDateT(executionDateTime);
        ((EbicsPartnerRepository)((Object)Beans.get(EbicsPartnerRepository.class))).save((Model)((Object)ebicsPartner));
        return bankStatementList;
    }

    @Override
    public void checkBankDetailsMissingCurrency(EbicsPartner ebicsPartner) throws AxelorException {
        List<com.axelor.apps.bankpayment.db.EbicsPartnerService> ebicsPartnerServiceSet = ebicsPartner.getBoEbicsPartnerServiceList();
        if (ebicsPartnerServiceSet == null) {
            return;
        }
        boolean allowOrderCurrDiffFromBankDetails = false;
        for (com.axelor.apps.bankpayment.db.EbicsPartnerService ebicsPartnerService : ebicsPartnerServiceSet) {
            if (!(allowOrderCurrDiffFromBankDetails = allowOrderCurrDiffFromBankDetails || ebicsPartnerService.getBankOrderFileFormat().getAllowOrderCurrDiffFromBankDetails() != false)) continue;
            break;
        }
        if (!allowOrderCurrDiffFromBankDetails) {
            return;
        }
        Set<BankDetails> bankDetailsSet = ebicsPartner.getBankDetailsSet();
        if (bankDetailsSet == null) {
            return;
        }
        ArrayList<String> bankDetailsWithoutCurrency = new ArrayList<String>();
        for (BankDetails bankDetails : bankDetailsSet) {
            if (bankDetails.getCurrency() != null) continue;
            bankDetailsWithoutCurrency.add(bankDetails.getFullName());
        }
        if (!bankDetailsWithoutCurrency.isEmpty()) {
            Function<String, String> addLi = new Function<String, String>(){

                public String apply(String s) {
                    return "<li>".concat(s).concat("</li>").toString();
                }
            };
            throw new AxelorException(String.format(I18n.get((String)"At least one bank details you have entered is missing currency. Here is the list of invalid bank details : %s"), "<ul>" + Joiner.on((String)"").join(Iterables.transform(bankDetailsWithoutCurrency, (Function)addLi)) + "<ul>"), 4, new Object[]{ebicsPartner});
        }
    }
}

