/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.service;

import com.axelor.app.AppSettings;
import com.axelor.apps.bankpayment.db.BankOrderFileFormat;
import com.axelor.apps.bankpayment.db.EbicsPartner;
import com.axelor.apps.bankpayment.db.EbicsPartnerService;
import com.axelor.apps.bankpayment.db.EbicsRequestLog;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.db.repo.EbicsRequestLogRepository;
import com.axelor.apps.bankpayment.db.repo.EbicsUserRepository;
import com.axelor.apps.bankpayment.ebics.client.EbicsProduct;
import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.client.FileTransfer;
import com.axelor.apps.bankpayment.ebics.client.KeyManagement;
import com.axelor.apps.bankpayment.ebics.client.OrderType;
import com.axelor.apps.bankpayment.ebics.io.IOUtils;
import com.axelor.apps.bankpayment.ebics.service.EbicsUserService;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.meta.MetaFiles;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Date;
import java.util.List;
import org.apache.xml.security.Init;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jdom.JDOMException;

public class EbicsService {
    @Inject
    private EbicsUserRepository userRepo;
    @Inject
    private EbicsRequestLogRepository logRepo;
    @Inject
    private EbicsUserService userService;
    @Inject
    private MetaFiles metaFiles;
    private EbicsProduct defaultProduct;

    @Inject
    public EbicsService() {
        AppSettings settings = AppSettings.get();
        String name = settings.get("application.name") + " " + settings.get("application.version");
        String language = settings.get("application.locale");
        String instituteID = settings.get("application.author");
        this.defaultProduct = new EbicsProduct(name, language, instituteID);
    }

    public String makeDN(EbicsUser ebicsUser) {
        String email = null;
        String companyName = this.defaultProduct.getInstituteID();
        User user = ebicsUser.getAssociatedUser();
        if (user != null) {
            email = user.getEmail();
            if (user.getActiveCompany() != null) {
                companyName = user.getActiveCompany().getName();
            }
        }
        return this.makeDN(ebicsUser.getName(), email, "FR", companyName);
    }

    private String makeDN(String name, String email, String country, String organization) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CN=" + name);
        if (country != null) {
            buffer.append(", C=" + country.toUpperCase());
        }
        if (organization != null) {
            buffer.append(", O=" + organization);
        }
        if (email != null) {
            buffer.append(", E=" + email);
        }
        return buffer.toString();
    }

    public RSAPublicKey getPublicKey(String modulus, String exponent) throws NoSuchAlgorithmException, InvalidKeySpecException {
        RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(modulus), new BigInteger(exponent));
        KeyFactory factory = KeyFactory.getInstance("RSA");
        RSAPublicKey pub = (RSAPublicKey)factory.generatePublic(spec);
        return pub;
    }

    public RSAPrivateKey getPrivateKey(byte[] encoded) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)kf.generatePrivate(keySpec);
    }

    @Transactional
    public void sendINIRequest(EbicsUser ebicsUser, EbicsProduct product) throws AxelorException {
        if (ebicsUser.getStatusSelect() != 1) {
            return;
        }
        try {
            this.userService.getNextOrderId(ebicsUser);
            EbicsSession session = new EbicsSession(ebicsUser);
            if (product == null) {
                product = this.defaultProduct;
            }
            session.setProduct(product);
            KeyManagement keyManager = new KeyManagement(session);
            keyManager.sendINI();
            ebicsUser.setStatusSelect(2);
            this.userRepo.save((Model)((Object)ebicsUser));
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException((Throwable)e, 4);
        }
    }

    @Transactional
    public void sendHIARequest(EbicsUser ebicsUser, EbicsProduct product) throws AxelorException {
        if (ebicsUser.getStatusSelect() != 2) {
            return;
        }
        this.userService.getNextOrderId(ebicsUser);
        EbicsSession session = new EbicsSession(ebicsUser);
        if (product == null) {
            product = this.defaultProduct;
        }
        session.setProduct(product);
        KeyManagement keyManager = new KeyManagement(session);
        try {
            keyManager.sendHIA();
            ebicsUser.setStatusSelect(3);
            this.userRepo.save((Model)((Object)ebicsUser));
        }
        catch (AxelorException | IOException | JDOMException e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException(e, 4);
        }
    }

    @Transactional
    public X509Certificate[] sendHPBRequest(EbicsUser user, EbicsProduct product) throws AxelorException {
        EbicsSession session = new EbicsSession(user);
        if (product == null) {
            product = this.defaultProduct;
        }
        session.setProduct(product);
        KeyManagement keyManager = new KeyManagement(session);
        try {
            return keyManager.sendHPB();
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException((Throwable)e, 4);
        }
    }

    @Transactional
    public void sendSPRRequest(EbicsUser ebicsUser, EbicsProduct product) throws AxelorException {
        EbicsSession session = new EbicsSession(ebicsUser);
        if (product == null) {
            product = this.defaultProduct;
        }
        session.setProduct(product);
        KeyManagement keyManager = new KeyManagement(session);
        try {
            keyManager.lockAccess();
            ebicsUser.setStatusSelect(1);
            this.userService.getNextOrderId(ebicsUser);
            this.userRepo.save((Model)((Object)ebicsUser));
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException((Throwable)e, 4);
        }
    }

    public void sendFULRequest(EbicsUser transportUser, EbicsUser signatoryUser, EbicsProduct product, File file, BankOrderFileFormat format, File signature) throws AxelorException {
        Preconditions.checkNotNull((Object)((Object)transportUser));
        Preconditions.checkNotNull((Object)((Object)transportUser.getEbicsPartner()));
        Preconditions.checkNotNull((Object)((Object)format));
        List<EbicsPartnerService> ebicsPartnerServiceList = transportUser.getEbicsPartner().getBoEbicsPartnerServiceList();
        String ebicsCodification = ebicsPartnerServiceList == null || ebicsPartnerServiceList.isEmpty() ? format.getOrderFileFormatSelect() : this.findEbicsCodification(transportUser.getEbicsPartner(), format);
        this.sendFULRequest(transportUser, signatoryUser, product, file, ebicsCodification, signature);
    }

    private String findEbicsCodification(EbicsPartner ebicsPartner, BankOrderFileFormat format) throws AxelorException {
        Preconditions.checkNotNull((Object)((Object)ebicsPartner));
        Preconditions.checkNotNull((Object)((Object)format));
        if (ebicsPartner.getBoEbicsPartnerServiceList() != null) {
            for (EbicsPartnerService service : ebicsPartner.getBoEbicsPartnerServiceList()) {
                if (!format.equals((Object)service.getBankOrderFileFormat())) continue;
                return service.getEbicsCodification();
            }
        }
        throw new AxelorException(I18n.get((String)"No service configured on EBICS partner %s for file format %s"), 4, new Object[]{ebicsPartner.getPartnerId(), format.getName()});
    }

    private void sendFULRequest(EbicsUser transportUser, EbicsUser signatoryUser, EbicsProduct product, File file, String format, File signature) throws AxelorException {
        EbicsSession session = new EbicsSession(transportUser, signatoryUser);
        boolean test = this.isTest(transportUser);
        if (test) {
            session.addSessionParam("TEST", "true");
        }
        if (file == null) {
            throw new AxelorException(4, "File is required to send FUL request");
        }
        EbicsPartner ebicsPartner = transportUser.getEbicsPartner();
        if (ebicsPartner.getEbicsTypeSelect() == 1) {
            if (signature == null) {
                throw new AxelorException(4, "Signature file is required to send FUL request");
            }
            if (signatoryUser == null) {
                throw new AxelorException(4, "Signatory user is required to send FUL request");
            }
        }
        session.addSessionParam("EBCDIC", "false");
        session.addSessionParam("FORMAT", format);
        if (product == null) {
            product = this.defaultProduct;
        }
        session.setProduct(product);
        FileTransfer transferManager = new FileTransfer(session);
        try {
            if (ebicsPartner.getEbicsTypeSelect() == 1) {
                transferManager.sendFile(IOUtils.getFileContent(file.getAbsolutePath()), OrderType.FUL, IOUtils.getFileContent(signature.getAbsolutePath()));
            } else {
                transferManager.sendFile(IOUtils.getFileContent(file.getAbsolutePath()), OrderType.FUL, null);
            }
            this.userService.getNextOrderId(transportUser);
        }
        catch (AxelorException | IOException e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException(e, 4);
        }
        try {
            if (ebicsPartner.getUsePSR().booleanValue()) {
                this.sendFDLRequest(transportUser, product, null, null, ebicsPartner.getpSRBankStatementFileFormat().getStatementFileFormatSelect());
            }
        }
        catch (AxelorException e) {
            TraceBackService.trace((AxelorException)e);
        }
    }

    public File sendFDLRequest(EbicsUser user, EbicsProduct product, Date start, Date end, String fileFormat) throws AxelorException {
        return this.fetchFile(OrderType.FDL, user, product, start, end, fileFormat);
    }

    public File sendHTDRequest(EbicsUser user, EbicsProduct product, Date start, Date end) throws AxelorException {
        return this.fetchFile(OrderType.HTD, user, product, start, end, null);
    }

    public File sendPTKRequest(EbicsUser user, EbicsProduct product, Date start, Date end) throws AxelorException {
        return this.fetchFile(OrderType.PTK, user, product, start, end, null);
    }

    public File sendHPDRequest(EbicsUser user, EbicsProduct product, Date start, Date end) throws AxelorException {
        return this.fetchFile(OrderType.HPD, user, product, start, end, null);
    }

    private File fetchFile(OrderType orderType, EbicsUser user, EbicsProduct product, Date start, Date end, String fileFormat) throws AxelorException {
        EbicsSession session = new EbicsSession(user);
        File file = null;
        try {
            boolean test = this.isTest(user);
            if (test) {
                session.addSessionParam("TEST", "true");
            }
            if (fileFormat != null) {
                session.addSessionParam("FORMAT", fileFormat);
            }
            if (product == null) {
                product = this.defaultProduct;
            }
            session.setProduct(product);
            FileTransfer transferManager = new FileTransfer(session);
            file = File.createTempFile(user.getName(), "." + orderType.getOrderType());
            transferManager.fetchFile(orderType, start, end, new FileOutputStream(file));
            this.addResponseFile(user, file);
            this.userService.getNextOrderId(user);
        }
        catch (AxelorException e) {
            TraceBackService.trace((AxelorException)e);
            throw e;
        }
        catch (IOException e) {
            TraceBackService.trace((Throwable)e);
            throw new AxelorException((Throwable)e, 4);
        }
        return file;
    }

    private boolean isTest(EbicsUser user) throws AxelorException {
        EbicsPartner partner = user.getEbicsPartner();
        return partner.getTestMode();
    }

    @Transactional
    public void addResponseFile(EbicsUser user, File file) throws IOException {
        EbicsRequestLog requestLog = (EbicsRequestLog)((Object)this.logRepo.all().filter("self.ebicsUser = ?1", new Object[]{user}).order("-id").fetchOne());
        if (requestLog != null && file != null && file.length() > 0L) {
            requestLog.setResponseFile(this.metaFiles.upload(file));
            this.logRepo.save((Model)((Object)requestLog));
        }
    }

    static {
        Init.init();
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

