/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.web;

import com.axelor.apps.bankpayment.db.BankStatement;
import com.axelor.apps.bankpayment.db.EbicsPartner;
import com.axelor.apps.bankpayment.db.repo.EbicsPartnerRepository;
import com.axelor.apps.bankpayment.ebics.service.EbicsPartnerService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.util.List;

@Singleton
public class EbicsPartnerController {
    public void getBankStatement(ActionRequest request, ActionResponse response) {
        try {
            EbicsPartner ebicsPartner = (EbicsPartner)((Object)request.getContext().asType(EbicsPartner.class));
            List<BankStatement> bankStatementList = ((EbicsPartnerService)Beans.get(EbicsPartnerService.class)).getBankStatements((EbicsPartner)((Object)((EbicsPartnerRepository)((Object)Beans.get(EbicsPartnerRepository.class))).find(ebicsPartner.getId())));
            response.setFlash(String.format(I18n.get((String)"%s bank statements get."), bankStatementList.size()));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        response.setReload(true);
    }

    public void checkBankDetailsSet(ActionRequest request, ActionResponse response) {
        EbicsPartner ebicsPartner = (EbicsPartner)((Object)request.getContext().asType(EbicsPartner.class));
        try {
            ((EbicsPartnerService)Beans.get(EbicsPartnerService.class)).checkBankDetailsMissingCurrency(ebicsPartner);
        }
        catch (Exception e) {
            response.setFlash(e.getMessage());
        }
    }
}

