/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.ebics.client.OrderType;
import com.axelor.apps.bankpayment.ebics.exception.ReturnCode;
import com.axelor.apps.bankpayment.ebics.interfaces.ContentFactory;
import com.axelor.apps.bankpayment.ebics.xml.InitializationResponseElement;
import com.axelor.exception.AxelorException;

public class DInitializationResponseElement
extends InitializationResponseElement {
    private int numSegments;
    private int segmentNumber;
    private boolean lastSegment;
    private byte[] transactionKey;
    private byte[] orderData;

    public DInitializationResponseElement(ContentFactory factory, OrderType orderType, String name, EbicsUser ebicsUser) {
        super(factory, orderType, name, ebicsUser);
    }

    @Override
    public void build() throws AxelorException {
        super.build();
        if (!this.returnCode.isOk()) {
            return;
        }
        String bodyRetCode = this.response.getBody().getReturnCode().getStringValue();
        this.returnCode = ReturnCode.toReturnCode(bodyRetCode, "");
        this.numSegments = (int)this.response.getHeader().getStatic().getNumSegments();
        if (this.numSegments > 0) {
            this.segmentNumber = (int)this.response.getHeader().getMutable().getSegmentNumber().getLongValue();
            this.lastSegment = this.response.getHeader().getMutable().getSegmentNumber().getLastSegment();
            this.transactionKey = this.response.getBody().getDataTransfer().getDataEncryptionInfo().getTransactionKey();
            this.orderData = this.response.getBody().getDataTransfer().getOrderData().getByteArrayValue();
        }
    }

    public int getSegmentsNumber() {
        return this.numSegments;
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public boolean isLastSegment() {
        return this.lastSegment;
    }

    public byte[] getTransactionKey() {
        return this.transactionKey;
    }

    public byte[] getOrderData() {
        return this.orderData;
    }
}

