/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.account.ebics.schema.h003.EbicsRequestDocument;
import com.axelor.apps.account.ebics.schema.h003.MutableHeaderType;
import com.axelor.apps.account.ebics.schema.h003.StaticHeaderType;
import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.client.OrderType;
import com.axelor.apps.bankpayment.ebics.xml.EbicsXmlFactory;
import com.axelor.apps.bankpayment.ebics.xml.TransferRequestElement;
import com.axelor.exception.AxelorException;

public class DTransferRequestElement
extends TransferRequestElement {
    public DTransferRequestElement(EbicsSession session, OrderType type, int segmentNumber, boolean lastSegment, byte[] transactionId) {
        super(session, DTransferRequestElement.generateName(type), type, segmentNumber, lastSegment, transactionId);
    }

    @Override
    public void buildTransfer() throws AxelorException {
        MutableHeaderType.SegmentNumber segmentNumber = EbicsXmlFactory.createSegmentNumber(this.segmentNumber, this.lastSegment);
        MutableHeaderType mutable = EbicsXmlFactory.createMutableHeaderType("Transfer", segmentNumber);
        StaticHeaderType xstatic = EbicsXmlFactory.createStaticHeaderType(this.session.getBankID(), this.transactionId);
        EbicsRequestDocument.EbicsRequest.Header header = EbicsXmlFactory.createEbicsRequestHeader(true, mutable, xstatic);
        EbicsRequestDocument.EbicsRequest.Body body = EbicsXmlFactory.createEbicsRequestBody();
        EbicsRequestDocument.EbicsRequest request = EbicsXmlFactory.createEbicsRequest(1, "H003", header, body);
        this.document = EbicsXmlFactory.createEbicsRequestDocument(request);
    }
}

