/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.ebics.client.EbicsRootElement;
import com.axelor.apps.bankpayment.ebics.exception.ReturnCode;
import com.axelor.apps.bankpayment.ebics.interfaces.ContentFactory;
import com.axelor.apps.bankpayment.ebics.service.EbicsUserService;
import com.axelor.apps.bankpayment.ebics.xml.DefaultEbicsRootElement;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import java.io.IOException;
import java.io.InputStream;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public abstract class DefaultResponseElement
extends DefaultEbicsRootElement {
    private String name;
    private EbicsUser ebicsUser;
    protected ContentFactory factory;
    protected ReturnCode returnCode;

    public DefaultResponseElement(ContentFactory factory, String name, EbicsUser ebicsUser) {
        this.factory = factory;
        this.name = name;
        this.ebicsUser = ebicsUser;
    }

    protected void parse(ContentFactory factory) throws AxelorException {
        try {
            this.document = XmlObject.Factory.parse((InputStream)factory.getContent());
        }
        catch (IOException | XmlException e) {
            throw new AxelorException(e.getCause(), 4, e.getMessage());
        }
    }

    public void report(EbicsRootElement[] rootElements) throws AxelorException {
        this.log(rootElements);
        if (!this.returnCode.isOk()) {
            this.returnCode.throwException();
        }
    }

    protected void log(EbicsRootElement[] rootElements) {
        if (this.ebicsUser != null && this.name != null && this.returnCode != null) {
            ((EbicsUserService)Beans.get(EbicsUserService.class)).logRequest(this.ebicsUser.getId(), this.name.substring(0, 3), this.returnCode.getSymbolicName(), rootElements);
            this.ebicsUser = null;
        }
    }

    @Override
    public String getName() {
        return this.name + ".xml";
    }
}

