/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.client.EbicsUtils;
import com.axelor.apps.bankpayment.ebics.client.OrderType;
import com.axelor.apps.bankpayment.ebics.client.UnsecuredRequestElement;
import com.axelor.apps.bankpayment.ebics.xml.DefaultEbicsRootElement;
import com.axelor.apps.bankpayment.ebics.xml.HIARequestOrderDataElement;
import com.axelor.exception.AxelorException;

public class HIARequestElement
extends DefaultEbicsRootElement {
    private UnsecuredRequestElement unsecuredRequest;

    public HIARequestElement(EbicsSession session) {
        super(session);
    }

    @Override
    public String getName() {
        return "HIARequest.xml";
    }

    @Override
    public void build() {
        HIARequestOrderDataElement requestOrderData = new HIARequestOrderDataElement(this.session);
        try {
            requestOrderData.build();
            this.unsecuredRequest = new UnsecuredRequestElement(this.session, OrderType.HIA, EbicsUtils.zip(requestOrderData.prettyPrint()));
            this.unsecuredRequest.build();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public byte[] toByteArray() {
        HIARequestElement.setSaveSuggestedPrefixes("http://www.ebics.org/H003", "");
        return this.unsecuredRequest.toByteArray();
    }

    @Override
    public void validate() throws AxelorException {
        this.unsecuredRequest.validate();
    }
}

