/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.account.ebics.schema.h003.AuthenticationPubKeyInfoType;
import com.axelor.apps.account.ebics.schema.h003.EncryptionPubKeyInfoType;
import com.axelor.apps.account.ebics.schema.h003.HIARequestOrderDataType;
import com.axelor.apps.account.ebics.schema.h003.PubKeyValueType;
import com.axelor.apps.account.ebics.schema.xmldsig.RSAKeyValueType;
import com.axelor.apps.account.ebics.schema.xmldsig.X509DataType;
import com.axelor.apps.bankpayment.db.EbicsCertificate;
import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.xml.DefaultEbicsRootElement;
import com.axelor.apps.bankpayment.ebics.xml.EbicsXmlFactory;
import java.math.BigInteger;
import java.util.Calendar;

public class HIARequestOrderDataElement
extends DefaultEbicsRootElement {
    public HIARequestOrderDataElement(EbicsSession session) {
        super(session);
    }

    @Override
    public void build() {
        X509DataType encryptionX509Data = null;
        X509DataType authX509Data = null;
        EbicsCertificate certificate = this.session.getUser().getE002Certificate();
        encryptionX509Data = EbicsXmlFactory.createX509DataType(this.session.getUser().getDn(), certificate.getCertificate());
        RSAKeyValueType encryptionRsaKeyValue = EbicsXmlFactory.createRSAKeyValueType(new BigInteger(certificate.getPublicKeyExponent(), 16).toByteArray(), new BigInteger(certificate.getPublicKeyModulus(), 16).toByteArray());
        PubKeyValueType encryptionPubKeyValue = EbicsXmlFactory.createH003PubKeyValueType(encryptionRsaKeyValue, Calendar.getInstance());
        EncryptionPubKeyInfoType encryptionPubKeyInfo = EbicsXmlFactory.createEncryptionPubKeyInfoType("E002", encryptionPubKeyValue, encryptionX509Data);
        certificate = this.session.getUser().getX002Certificate();
        authX509Data = EbicsXmlFactory.createX509DataType(this.session.getUser().getDn(), certificate.getCertificate());
        RSAKeyValueType authRsaKeyValue = EbicsXmlFactory.createRSAKeyValueType(new BigInteger(certificate.getPublicKeyExponent(), 16).toByteArray(), new BigInteger(certificate.getPublicKeyModulus(), 16).toByteArray());
        PubKeyValueType authPubKeyValue = EbicsXmlFactory.createH003PubKeyValueType(authRsaKeyValue, Calendar.getInstance());
        AuthenticationPubKeyInfoType authenticationPubKeyInfo = EbicsXmlFactory.createAuthenticationPubKeyInfoType("X002", authPubKeyValue, authX509Data);
        HIARequestOrderDataType request = EbicsXmlFactory.createHIARequestOrderDataType(authenticationPubKeyInfo, encryptionPubKeyInfo, this.session.getUser().getEbicsPartner().getPartnerId(), this.session.getUser().getUserId());
        this.document = EbicsXmlFactory.createHIARequestOrderDataDocument(request);
    }

    @Override
    public String getName() {
        return "HIARequestOrderData.xml";
    }

    @Override
    public byte[] toByteArray() {
        this.addNamespaceDecl("ds", "http://www.w3.org/2000/09/xmldsig#");
        HIARequestOrderDataElement.setSaveSuggestedPrefixes("http://www.ebics.org/S001", "");
        return super.toByteArray();
    }
}

