/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.client.EbicsUtils;
import com.axelor.apps.bankpayment.ebics.client.OrderType;
import com.axelor.apps.bankpayment.ebics.client.UnsecuredRequestElement;
import com.axelor.apps.bankpayment.ebics.xml.DefaultEbicsRootElement;
import com.axelor.apps.bankpayment.ebics.xml.SignaturePubKeyOrderDataElement;
import com.axelor.exception.AxelorException;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INIRequestElement
extends DefaultEbicsRootElement {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private UnsecuredRequestElement unsecuredRequest;

    public INIRequestElement(EbicsSession session) {
        super(session);
    }

    @Override
    public String getName() {
        return "INIRequest.xml";
    }

    @Override
    public void build() throws AxelorException {
        SignaturePubKeyOrderDataElement signaturePubKey = new SignaturePubKeyOrderDataElement(this.session);
        this.log.debug("SignaturePubKeyOrderDataElement OK");
        signaturePubKey.build();
        this.log.debug("signaturePubKey.build OK");
        this.unsecuredRequest = new UnsecuredRequestElement(this.session, OrderType.INI, EbicsUtils.zip(signaturePubKey.prettyPrint()));
        this.log.debug("UnsecuredRequestElement OK");
        this.unsecuredRequest.build();
        this.log.debug("unsecuredRequest.build OK");
    }

    @Override
    public byte[] toByteArray() {
        INIRequestElement.setSaveSuggestedPrefixes("http://www.ebics.org/H003", "");
        return this.unsecuredRequest.toByteArray();
    }

    @Override
    public void validate() throws AxelorException {
        this.unsecuredRequest.validate();
    }
}

