/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.account.ebics.schema.h003.EbicsRequestDocument;
import com.axelor.apps.account.ebics.schema.h003.MutableHeaderType;
import com.axelor.apps.account.ebics.schema.h003.StaticHeaderType;
import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.client.EbicsUtils;
import com.axelor.apps.bankpayment.ebics.xml.DefaultEbicsRootElement;
import com.axelor.apps.bankpayment.ebics.xml.EbicsXmlFactory;
import com.axelor.apps.bankpayment.ebics.xml.SignedInfo;
import com.axelor.exception.AxelorException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class ReceiptRequestElement
extends DefaultEbicsRootElement {
    private byte[] transactionId;
    private String name;

    public ReceiptRequestElement(EbicsSession session, byte[] transactionId, String name) {
        super(session);
        this.transactionId = transactionId;
        this.name = name;
    }

    @Override
    public void build() throws AxelorException {
        MutableHeaderType mutable = EbicsXmlFactory.createMutableHeaderType("Receipt", null);
        StaticHeaderType xstatic = EbicsXmlFactory.createStaticHeaderType(this.session.getBankID(), this.transactionId);
        EbicsRequestDocument.EbicsRequest.Header header = EbicsXmlFactory.createEbicsRequestHeader(true, mutable, xstatic);
        EbicsRequestDocument.EbicsRequest.Body.TransferReceipt transferReceipt = EbicsXmlFactory.createTransferReceipt(true, 0);
        EbicsRequestDocument.EbicsRequest.Body body = EbicsXmlFactory.createEbicsRequestBody(transferReceipt);
        EbicsRequestDocument.EbicsRequest request = EbicsXmlFactory.createEbicsRequest(1, "H003", header, body);
        this.document = EbicsXmlFactory.createEbicsRequestDocument(request);
        SignedInfo signedInfo = new SignedInfo(this.session.getUser(), this.getDigest());
        signedInfo.build();
        ((EbicsRequestDocument)this.document).getEbicsRequest().setAuthSignature(signedInfo.getSignatureType());
        ((EbicsRequestDocument)this.document).getEbicsRequest().getAuthSignature().setSignatureValue(EbicsXmlFactory.createSignatureValueType(signedInfo.sign(this.toByteArray())));
    }

    @Override
    public byte[] toByteArray() {
        ReceiptRequestElement.setSaveSuggestedPrefixes("http://www.ebics.org/H003", "");
        return super.toByteArray();
    }

    @Override
    public String getName() {
        return this.name + ".xml";
    }

    public byte[] getDigest() throws AxelorException {
        this.addNamespaceDecl("ds", "http://www.w3.org/2000/09/xmldsig#");
        try {
            return MessageDigest.getInstance("SHA-256", "BC").digest(EbicsUtils.canonize(this.toByteArray()));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new AxelorException(e.getCause(), 4, e.getMessage());
        }
    }
}

