/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.account.ebics.schema.s001.PubKeyValueType;
import com.axelor.apps.account.ebics.schema.s001.SignaturePubKeyInfoType;
import com.axelor.apps.account.ebics.schema.s001.SignaturePubKeyOrderDataType;
import com.axelor.apps.account.ebics.schema.xmldsig.RSAKeyValueType;
import com.axelor.apps.account.ebics.schema.xmldsig.X509DataType;
import com.axelor.apps.bankpayment.db.EbicsCertificate;
import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.xml.DefaultEbicsRootElement;
import com.axelor.apps.bankpayment.ebics.xml.EbicsXmlFactory;
import com.axelor.exception.AxelorException;
import java.math.BigInteger;
import java.util.Calendar;

public class SignaturePubKeyOrderDataElement
extends DefaultEbicsRootElement {
    public SignaturePubKeyOrderDataElement(EbicsSession session) {
        super(session);
    }

    @Override
    public void build() throws AxelorException {
        EbicsCertificate certificate = this.session.getUser().getA005Certificate();
        System.out.println("Certificate : " + new String(certificate.getCertificate()));
        System.out.println("Certificate size : " + certificate.getCertificate().length);
        EbicsCertificate ebicsEertificate = this.session.getUser().getA005Certificate();
        X509DataType x509Data = EbicsXmlFactory.createX509DataType(ebicsEertificate.getSubject(), ebicsEertificate.getCertificate());
        RSAKeyValueType rsaKeyValue = EbicsXmlFactory.createRSAKeyValueType(new BigInteger(ebicsEertificate.getPublicKeyExponent(), 16).toByteArray(), new BigInteger(ebicsEertificate.getPublicKeyModulus(), 16).toByteArray());
        PubKeyValueType pubKeyValue = EbicsXmlFactory.createPubKeyValueType(rsaKeyValue, Calendar.getInstance());
        SignaturePubKeyInfoType signaturePubKeyInfo = EbicsXmlFactory.createSignaturePubKeyInfoType(x509Data, pubKeyValue, "A005");
        SignaturePubKeyOrderDataType signaturePubKeyOrderData = EbicsXmlFactory.createSignaturePubKeyOrderData(signaturePubKeyInfo, this.session.getUser().getEbicsPartner().getPartnerId(), this.session.getUser().getUserId());
        this.document = EbicsXmlFactory.createSignaturePubKeyOrderDataDocument(signaturePubKeyOrderData);
    }

    @Override
    public String getName() {
        return "SignaturePubKeyOrderData.xml";
    }

    @Override
    public byte[] toByteArray() {
        this.addNamespaceDecl("ds", "http://www.w3.org/2000/09/xmldsig#");
        SignaturePubKeyOrderDataElement.setSaveSuggestedPrefixes("http://www.ebics.org/S001", "");
        return super.toByteArray();
    }
}

