/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.account.ebics.schema.xmldsig.CanonicalizationMethodType;
import com.axelor.apps.account.ebics.schema.xmldsig.DigestMethodType;
import com.axelor.apps.account.ebics.schema.xmldsig.ReferenceType;
import com.axelor.apps.account.ebics.schema.xmldsig.SignatureMethodType;
import com.axelor.apps.account.ebics.schema.xmldsig.SignatureType;
import com.axelor.apps.account.ebics.schema.xmldsig.SignedInfoType;
import com.axelor.apps.account.ebics.schema.xmldsig.TransformType;
import com.axelor.apps.account.ebics.schema.xmldsig.TransformsType;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.ebics.service.EbicsUserService;
import com.axelor.apps.bankpayment.ebics.xml.DefaultEbicsRootElement;
import com.axelor.apps.bankpayment.ebics.xml.EbicsXmlFactory;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;

public class SignedInfo
extends DefaultEbicsRootElement {
    private byte[] digest;
    private EbicsUser user;

    public SignedInfo(EbicsUser user, byte[] digest) {
        this.user = user;
        this.digest = digest;
    }

    @Override
    public void build() throws AxelorException {
        if (this.digest == null) {
            throw new AxelorException(4, I18n.get((String)"digest value cannot be null"));
        }
        TransformType transform = EbicsXmlFactory.createTransformType("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        DigestMethodType digestMethod = EbicsXmlFactory.createDigestMethodType("http://www.w3.org/2001/04/xmlenc#sha256");
        TransformsType transforms = EbicsXmlFactory.createTransformsType(new TransformType[]{transform});
        ReferenceType reference = EbicsXmlFactory.createReferenceType("#xpointer(//*[@authenticate='true'])", transforms, digestMethod, this.digest);
        SignatureMethodType signatureMethod = EbicsXmlFactory.createSignatureMethodType("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        CanonicalizationMethodType canonicalizationMethod = EbicsXmlFactory.createCanonicalizationMethodType("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        SignedInfoType signedInfo = EbicsXmlFactory.createSignedInfoType(canonicalizationMethod, signatureMethod, new ReferenceType[]{reference});
        this.document = EbicsXmlFactory.createSignatureType(signedInfo);
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public SignatureType getSignatureType() {
        return (SignatureType)this.document;
    }

    public byte[] sign(byte[] toSign) throws AxelorException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
            Document document = builder.parse(new ByteArrayInputStream(toSign));
            Node node = XPathAPI.selectSingleNode((Node)document, (String)"//ds:SignedInfo");
            Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            return ((EbicsUserService)Beans.get(EbicsUserService.class)).authenticate(this.user, canonicalizer.canonicalizeSubtree(node));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AxelorException((Throwable)e, 4);
        }
    }

    @Override
    public byte[] toByteArray() {
        this.addNamespaceDecl("", "http://www.ebics.org/H003");
        SignedInfo.setSaveSuggestedPrefixes("http://www.w3.org/2000/09/xmldsig#", "ds");
        return super.toByteArray();
    }

    @Override
    public String getName() {
        return "SignedInfo.xml";
    }
}

