/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.account.ebics.schema.h003.EbicsRequestDocument;
import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.client.EbicsUtils;
import com.axelor.apps.bankpayment.ebics.client.OrderType;
import com.axelor.apps.bankpayment.ebics.xml.DefaultEbicsRootElement;
import com.axelor.apps.bankpayment.ebics.xml.EbicsXmlFactory;
import com.axelor.apps.bankpayment.ebics.xml.SignedInfo;
import com.axelor.exception.AxelorException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public abstract class TransferRequestElement
extends DefaultEbicsRootElement {
    protected int segmentNumber;
    protected boolean lastSegment;
    protected byte[] transactionId;
    private OrderType type;
    private String name;

    public TransferRequestElement(EbicsSession session, String name, OrderType type, int segmentNumber, boolean lastSegment, byte[] transactionId) {
        super(session);
        this.type = type;
        this.name = name;
        this.segmentNumber = segmentNumber;
        this.lastSegment = lastSegment;
        this.transactionId = transactionId;
    }

    @Override
    public void build() throws AxelorException {
        this.buildTransfer();
        SignedInfo signedInfo = new SignedInfo(this.session.getUser(), this.getDigest());
        signedInfo.build();
        ((EbicsRequestDocument)this.document).getEbicsRequest().setAuthSignature(signedInfo.getSignatureType());
        ((EbicsRequestDocument)this.document).getEbicsRequest().getAuthSignature().setSignatureValue(EbicsXmlFactory.createSignatureValueType(signedInfo.sign(this.toByteArray())));
    }

    @Override
    public String getName() {
        return this.name + ".xml";
    }

    public byte[] getDigest() throws AxelorException {
        this.addNamespaceDecl("ds", "http://www.w3.org/2000/09/xmldsig#");
        try {
            return MessageDigest.getInstance("SHA-256", "BC").digest(EbicsUtils.canonize(this.toByteArray()));
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new AxelorException(e.getCause(), 4, e.getMessage());
        }
    }

    public String getOrderType() {
        return this.type.getOrderType();
    }

    @Override
    public byte[] toByteArray() {
        TransferRequestElement.setSaveSuggestedPrefixes("http://www.ebics.org/H003", "");
        return super.toByteArray();
    }

    public abstract void buildTransfer() throws AxelorException;
}

