/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.account.ebics.schema.h003.DataEncryptionInfoType;
import com.axelor.apps.account.ebics.schema.h003.DataTransferRequestType;
import com.axelor.apps.account.ebics.schema.h003.EbicsRequestDocument;
import com.axelor.apps.account.ebics.schema.h003.FULOrderParamsType;
import com.axelor.apps.account.ebics.schema.h003.FileFormatType;
import com.axelor.apps.account.ebics.schema.h003.MutableHeaderType;
import com.axelor.apps.account.ebics.schema.h003.ParameterDocument;
import com.axelor.apps.account.ebics.schema.h003.StaticHeaderOrderDetailsType;
import com.axelor.apps.account.ebics.schema.h003.StaticHeaderType;
import com.axelor.apps.bankpayment.db.EbicsPartner;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.ebics.certificate.KeyUtil;
import com.axelor.apps.bankpayment.ebics.client.EbicsSession;
import com.axelor.apps.bankpayment.ebics.client.EbicsUtils;
import com.axelor.apps.bankpayment.ebics.client.OrderAttribute;
import com.axelor.apps.bankpayment.ebics.client.OrderType;
import com.axelor.apps.bankpayment.ebics.interfaces.ContentFactory;
import com.axelor.apps.bankpayment.ebics.io.Splitter;
import com.axelor.apps.bankpayment.ebics.xml.EbicsXmlFactory;
import com.axelor.apps.bankpayment.ebics.xml.InitializationRequestElement;
import com.axelor.apps.bankpayment.ebics.xml.UserSignature;
import com.axelor.exception.AxelorException;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import javax.crypto.spec.SecretKeySpec;
import org.jdom.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UInitializationRequestElement
extends InitializationRequestElement {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private byte[] userData;
    private byte[] userSignatureData;
    private UserSignature userSignature;
    private SecretKeySpec keySpec;
    private Splitter splitter;

    public UInitializationRequestElement(EbicsSession session, OrderType orderType, byte[] userData, byte[] userSignatureData) throws AxelorException {
        super(session, orderType, UInitializationRequestElement.generateName(orderType));
        this.userData = userData;
        this.userSignatureData = userSignatureData;
        this.keySpec = new SecretKeySpec(this.nonce, "EAS");
        this.splitter = new Splitter(userData);
    }

    @Override
    public void buildInitialization() throws AxelorException {
        ParameterDocument.Parameter parameter;
        ParameterDocument.Parameter.Value value;
        EbicsUser ebicsUser = this.session.getUser();
        EbicsPartner ebicsPartner = ebicsUser.getEbicsPartner();
        if (ebicsPartner.getEbicsTypeSelect() == 1) {
            EbicsUser signatoryUser = this.session.getSignatoryUser();
            this.userSignature = new UserSignature(signatoryUser, UInitializationRequestElement.generateName("UserSignature"), "A005", this.userData, this.userSignatureData);
        } else {
            this.userSignature = new UserSignature(ebicsUser, UInitializationRequestElement.generateName("UserSignature"), "A005", this.userData, null);
        }
        this.userSignature.build();
        this.log.debug("user signature pretty print : {}", (Object)this.userSignature.toString());
        this.userSignature.validate();
        this.log.debug("user signature pretty print : {}", (Object)this.userSignature.toString());
        this.splitter.readInput(true, this.keySpec);
        MutableHeaderType mutable = EbicsXmlFactory.createMutableHeaderType("Initialisation", null);
        StaticHeaderType.Product product = EbicsXmlFactory.createProduct(this.session.getProduct().getLanguage(), this.session.getProduct().getName());
        StaticHeaderType.BankPubKeyDigests.Authentication authentication = EbicsXmlFactory.createAuthentication("X002", "http://www.w3.org/2001/04/xmlenc#sha256", this.decodeHex(KeyUtil.getKeyDigest(this.session.getBankX002Key())));
        StaticHeaderType.BankPubKeyDigests.Encryption encryption = EbicsXmlFactory.createEncryption("E002", "http://www.w3.org/2001/04/xmlenc#sha256", this.decodeHex(KeyUtil.getKeyDigest(this.session.getBankE002Key())));
        StaticHeaderType.BankPubKeyDigests bankPubKeyDigests = EbicsXmlFactory.createBankPubKeyDigests(authentication, encryption);
        StaticHeaderOrderDetailsType.OrderType orderType = EbicsXmlFactory.createOrderType(this.type.getOrderType());
        FileFormatType fileFormat = EbicsXmlFactory.createFileFormatType(Locale.FRANCE.getCountry(), this.session.getSessionParam("FORMAT"));
        FULOrderParamsType fULOrderParams = EbicsXmlFactory.createFULOrderParamsType(fileFormat);
        ArrayList<ParameterDocument.Parameter> parameters = new ArrayList<ParameterDocument.Parameter>();
        if (Boolean.valueOf(this.session.getSessionParam("TEST")).booleanValue()) {
            value = EbicsXmlFactory.createValue("String", "TRUE");
            parameter = EbicsXmlFactory.createParameter("TEST", value);
            parameters.add(parameter);
        }
        if (Boolean.valueOf(this.session.getSessionParam("EBCDIC")).booleanValue()) {
            value = EbicsXmlFactory.createValue("String", "TRUE");
            parameter = EbicsXmlFactory.createParameter("EBCDIC", value);
            parameters.add(parameter);
        }
        if (parameters.size() > 0) {
            fULOrderParams.setParameterArray(parameters.toArray(new ParameterDocument.Parameter[parameters.size()]));
        }
        OrderAttribute orderAttribute = new OrderAttribute(this.type, ebicsPartner.getEbicsTypeSelect());
        orderAttribute.build();
        StaticHeaderOrderDetailsType orderDetails = EbicsXmlFactory.createStaticHeaderOrderDetailsType(ebicsUser.getNextOrderId(), orderAttribute.getOrderAttributes(), orderType, fULOrderParams);
        StaticHeaderType xstatic = EbicsXmlFactory.createStaticHeaderType(this.session.getBankID(), this.nonce, this.splitter.getSegmentNumber(), ebicsPartner.getPartnerId(), product, ebicsUser.getSecurityMedium(), ebicsUser.getUserId(), Calendar.getInstance(), orderDetails, bankPubKeyDigests);
        EbicsRequestDocument.EbicsRequest.Header header = EbicsXmlFactory.createEbicsRequestHeader(true, mutable, xstatic);
        DataEncryptionInfoType.EncryptionPubKeyDigest encryptionPubKeyDigest = EbicsXmlFactory.createEncryptionPubKeyDigest("E002", "http://www.w3.org/2001/04/xmlenc#sha256", this.decodeHex(KeyUtil.getKeyDigest(this.session.getBankE002Key())));
        System.out.println("signature ----------------------------------------------------------------------------");
        System.out.println(this.userSignature.toString());
        DataTransferRequestType.SignatureData signatureData = EbicsXmlFactory.createSignatureData(true, EbicsUtils.encrypt(EbicsUtils.zip(this.userSignature.prettyPrint()), this.keySpec));
        DataTransferRequestType.DataEncryptionInfo dataEncryptionInfo = EbicsXmlFactory.createDataEncryptionInfo(true, encryptionPubKeyDigest, this.generateTransactionKey());
        DataTransferRequestType dataTransfer = EbicsXmlFactory.createDataTransferRequestType(dataEncryptionInfo, signatureData);
        EbicsRequestDocument.EbicsRequest.Body body = EbicsXmlFactory.createEbicsRequestBody(dataTransfer);
        EbicsRequestDocument.EbicsRequest request = EbicsXmlFactory.createEbicsRequest(1, "H003", header, body);
        this.document = EbicsXmlFactory.createEbicsRequestDocument(request);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            this.save(bout);
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        System.out.println("Requete signature ----------------------------------------------------------------------------");
        System.out.println(bout.toString());
    }

    @Override
    public byte[] toByteArray() {
        UInitializationRequestElement.setSaveSuggestedPrefixes("http://www.ebics.org/H003", "");
        return super.toByteArray();
    }

    public UserSignature getUserSignature() {
        return this.userSignature;
    }

    public ContentFactory getContent(int segment) {
        return this.splitter.getContent(segment);
    }

    public int getSegmentNumber() {
        return this.splitter.getSegmentNumber();
    }
}

