/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.ebics.xml;

import com.axelor.apps.account.ebics.schema.s001.OrderSignatureDataType;
import com.axelor.apps.account.ebics.schema.s001.UserSignatureDataSigBookType;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.ebics.service.EbicsUserService;
import com.axelor.apps.bankpayment.ebics.xml.DefaultEbicsRootElement;
import com.axelor.apps.bankpayment.ebics.xml.EbicsXmlFactory;
import com.axelor.apps.bankpayment.ebics.xml.UserSignatureVerify;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSignature
extends DefaultEbicsRootElement {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private EbicsUser user;
    private String signatureVersion;
    private byte[] data;
    private byte[] signature;
    private String name;

    public UserSignature(EbicsUser user, String name, String signatureVersion, byte[] data, byte[] signature) {
        this.user = user;
        this.data = data;
        this.signature = signature;
        this.name = name;
        this.signatureVersion = signatureVersion;
    }

    @Override
    public void build() throws AxelorException {
        try {
            if (this.user.getEbicsPartner().getEbicsTypeSelect() == 1) {
                this.log.debug("Signature (base64) : {}", (Object)new String(this.signature));
                this.log.debug("Signature (base64) length : {}", (Object)this.signature.length);
                this.signature = EbicsUserService.removeOSSpecificChars(this.signature);
                this.log.debug("Signature (base64) length after remove OS specific chars : {}", (Object)this.signature.length);
                this.signature = Base64.getDecoder().decode(this.signature);
                this.log.debug("Signature (byte) length : {}", (Object)this.signature.length);
            } else {
                this.signature = ((EbicsUserService)Beans.get(EbicsUserService.class)).sign(this.user, this.data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UserSignatureVerify userSignatureVerify = new UserSignatureVerify(this.user, this.data, this.signature);
        userSignatureVerify.verify();
        OrderSignatureDataType orderSignatureData = EbicsXmlFactory.createOrderSignatureDataType(this.signatureVersion, this.user.getEbicsPartner().getPartnerId(), this.user.getUserId(), this.signature);
        UserSignatureDataSigBookType userSignatureData = EbicsXmlFactory.createUserSignatureDataSigBookType(new OrderSignatureDataType[]{orderSignatureData});
        this.document = EbicsXmlFactory.createUserSignatureDataDocument(userSignatureData);
    }

    @Override
    public String getName() {
        return this.name + ".xml";
    }

    @Override
    public byte[] toByteArray() {
        this.addNamespaceDecl("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        UserSignature.setSaveSuggestedPrefixes("http://www.ebics.org/S001", "");
        this.insertSchemaLocation("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "xsi", "http://www.ebics.org/S001 http://www.ebics.org/S001/ebics_signature.xsd");
        return super.toByteArray();
    }
}

