/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.account.db.AccountingReport;
import com.axelor.apps.account.db.repo.AccountRepository;
import com.axelor.apps.account.db.repo.AccountingReportRepository;
import com.axelor.apps.account.service.AccountingReportServiceImpl;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.bankpayment.service.AccountingReportBankPaymentService;
import com.axelor.apps.base.service.BankDetailsService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;

public class AccountingReportBankPaymentServiceImpl
extends AccountingReportServiceImpl
implements AccountingReportBankPaymentService {
    @Inject
    public AccountingReportBankPaymentServiceImpl(AppAccountService appBaseService, AccountingReportRepository accountingReportRepo, AccountRepository accountRepo) {
        super(appBaseService, accountingReportRepo, accountRepo);
    }

    @Override
    public String createDomainForBankDetails(AccountingReport accountingReport) {
        return ((BankDetailsService)Beans.get(BankDetailsService.class)).getActiveCompanyBankDetails(accountingReport.getCompany(), accountingReport.getCurrency());
    }

    public String getReportFileLink(AccountingReport accountingReport, String name) throws AxelorException {
        if (accountingReport.getTypeSelect() == 18) {
            return ReportFactory.createReport((String)"BankReconciliationStatement.rptdesign", (String)(name + "-${date}")).addParam("AccountingReportId", (Object)accountingReport.getId()).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addFormat(accountingReport.getExportTypeSelect()).toAttach((Model)((Object)accountingReport)).generate().getFileLink();
        }
        return super.getReportFileLink(accountingReport, name);
    }
}

