/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.app;

import com.axelor.apps.bankpayment.db.BankPaymentConfig;
import com.axelor.apps.bankpayment.db.repo.BankPaymentConfigRepository;
import com.axelor.apps.bankpayment.service.app.AppBankPaymentService;
import com.axelor.apps.base.db.AppBankPayment;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.repo.AppBankPaymentRepository;
import com.axelor.apps.base.db.repo.CompanyRepository;
import com.axelor.apps.base.service.app.AppBaseServiceImpl;
import com.axelor.db.Model;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.util.List;

@Singleton
public class AppBankPaymentServiceImpl
extends AppBaseServiceImpl
implements AppBankPaymentService {
    protected AppBankPaymentRepository appBankPaymentRepo;
    protected BankPaymentConfigRepository bankPaymentConfigRepo;
    protected CompanyRepository companyRepo;

    @Inject
    AppBankPaymentServiceImpl(AppBankPaymentRepository appBankPaymentRepo, BankPaymentConfigRepository bankPaymentConfigRepo, CompanyRepository companyRepo) {
        this.appBankPaymentRepo = appBankPaymentRepo;
        this.bankPaymentConfigRepo = bankPaymentConfigRepo;
        this.companyRepo = companyRepo;
    }

    @Override
    public AppBankPayment getAppBankPayment() {
        return (AppBankPayment)((Object)this.appBankPaymentRepo.all().fetchOne());
    }

    @Override
    @Transactional
    public void generateBankPaymentConfigurations() {
        List companies = this.companyRepo.all().filter("self.bankPaymentConfig IS NULL").fetch();
        for (Company company : companies) {
            BankPaymentConfig config = new BankPaymentConfig();
            config.setCompany(company);
            this.bankPaymentConfigRepo.save((Model)((Object)config));
        }
    }
}

