/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankorder;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.BankOrderFileFormat;
import com.axelor.apps.bankpayment.db.BankOrderLine;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.bankpayment.db.repo.BankOrderRepository;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderLineService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BankOrderCreateService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected BankOrderRepository bankOrderRepo;
    protected BankOrderService bankOrderService;
    protected BankOrderLineService bankOrderLineService;
    protected InvoiceService invoiceService;

    @Inject
    public BankOrderCreateService(BankOrderRepository bankOrderRepo, BankOrderService bankOrderService, BankOrderLineService bankOrderLineService, InvoiceService invoiceService) {
        this.bankOrderRepo = bankOrderRepo;
        this.bankOrderService = bankOrderService;
        this.bankOrderLineService = bankOrderLineService;
        this.invoiceService = invoiceService;
    }

    public BankOrder createBankOrder(PaymentMode paymentMode, Integer partnerType, LocalDate bankOrderDate, Company senderCompany, BankDetails senderBankDetails, Currency currency, String senderReference, String senderLabel, int technicalOriginSelect) throws AxelorException {
        BankOrderFileFormat bankOrderFileFormat = paymentMode.getBankOrderFileFormat();
        BankOrder bankOrder = new BankOrder();
        bankOrder.setOrderTypeSelect(paymentMode.getOrderTypeSelect());
        bankOrder.setPaymentMode(paymentMode);
        bankOrder.setPartnerTypeSelect(partnerType);
        if (!bankOrderFileFormat.getIsMultiDate().booleanValue()) {
            bankOrder.setBankOrderDate(bankOrderDate);
        }
        bankOrder.setStatusSelect(1);
        bankOrder.setRejectStatusSelect(0);
        bankOrder.setSenderCompany(senderCompany);
        bankOrder.setSenderBankDetails(senderBankDetails);
        EbicsUser signatoryEbicsUser = this.bankOrderService.getDefaultEbicsUserFromBankDetails(senderBankDetails);
        User signatoryUser = null;
        if (signatoryEbicsUser != null) {
            signatoryUser = signatoryEbicsUser.getAssociatedUser();
            bankOrder.setSignatoryEbicsUser(signatoryEbicsUser);
        }
        if (signatoryUser != null) {
            bankOrder.setSignatoryUser(signatoryUser);
        }
        if (!bankOrderFileFormat.getIsMultiCurrency().booleanValue()) {
            bankOrder.setBankOrderCurrency(currency);
        }
        bankOrder.setCompanyCurrency(senderCompany.getCurrency());
        bankOrder.setSenderReference(senderReference);
        bankOrder.setSenderLabel(senderLabel);
        bankOrder.setBankOrderLineList(new ArrayList<BankOrderLine>());
        bankOrder.setBankOrderFileFormat(bankOrderFileFormat);
        bankOrder.setTechnicalOriginSelect(technicalOriginSelect);
        return bankOrder;
    }

    public BankOrder createBankOrder(InvoicePayment invoicePayment) throws AxelorException {
        Invoice invoice = invoicePayment.getInvoice();
        Company company = invoice.getCompany();
        PaymentMode paymentMode = invoicePayment.getPaymentMode();
        Partner partner = invoice.getPartner();
        BigDecimal amount = invoicePayment.getAmount();
        Currency currency = invoicePayment.getCurrency();
        LocalDate paymentDate = invoicePayment.getPaymentDate();
        BankDetails companyBankDetails = invoicePayment.getCompanyBankDetails() != null ? invoicePayment.getCompanyBankDetails() : this.getSenderBankDetails(invoice);
        String reference = InvoiceToolService.isPurchase((Invoice)invoice) ? invoice.getSupplierInvoiceNb() : invoice.getInvoiceId();
        BankOrder bankOrder = this.createBankOrder(paymentMode, this.getBankOrderPartnerType(invoice), paymentDate, company, companyBankDetails, currency, reference, null, 1);
        BankDetails receiverBankDetails = this.invoiceService.getBankDetails(invoice);
        BankOrderLine bankOrderLine = this.bankOrderLineService.createBankOrderLine(paymentMode.getBankOrderFileFormat(), null, partner, receiverBankDetails, amount, currency, paymentDate, reference, null, (Model)invoice);
        bankOrder.addBankOrderLineListItem(bankOrderLine);
        bankOrder = (BankOrder)((Object)this.bankOrderRepo.save((Model)((Object)bankOrder)));
        return bankOrder;
    }

    public int getBankOrderPartnerType(Invoice invoice) {
        if (invoice.getOperationTypeSelect() == 4 || invoice.getOperationTypeSelect() == 3) {
            return 3;
        }
        return 1;
    }

    public BankDetails getSenderBankDetails(Invoice invoice) {
        if (invoice.getBankDetails() != null) {
            return invoice.getCompanyBankDetails();
        }
        return invoice.getCompany().getDefaultBankDetails();
    }
}

