/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankorder;

import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.BankOrderFileFormat;
import com.axelor.apps.bankpayment.db.BankOrderLine;
import com.axelor.apps.bankpayment.db.EbicsPartner;
import com.axelor.apps.bankpayment.db.repo.EbicsPartnerRepository;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderLineOriginService;
import com.axelor.apps.bankpayment.service.bankorder.BankOrderService;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.Bank;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.BankDetailsRepository;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.tool.StringTool;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.CallMethod;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BankOrderLineService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected BankDetailsRepository bankDetailsRepo;
    protected CurrencyService currencyService;
    protected BankOrderLineOriginService bankOrderLineOriginService;

    @Inject
    public BankOrderLineService(BankDetailsRepository bankDetailsRepo, CurrencyService currencyService, BankOrderLineOriginService bankOrderLineOriginService) {
        this.bankDetailsRepo = bankDetailsRepo;
        this.currencyService = currencyService;
        this.bankOrderLineOriginService = bankOrderLineOriginService;
    }

    public BankOrderLine createBankOrderLine(BankOrderFileFormat bankOrderFileFormat, Partner partner, BigDecimal amount, Currency currency, LocalDate bankOrderDate, String receiverReference, String receiverLabel, Model origin) throws AxelorException {
        BankDetails receiverBankDetails = this.bankDetailsRepo.findDefaultByPartner(partner);
        return this.createBankOrderLine(bankOrderFileFormat, null, partner, receiverBankDetails, amount, currency, bankOrderDate, receiverReference, receiverLabel, origin);
    }

    public BankOrderLine createBankOrderLine(BankOrderFileFormat bankOrderFileFormat, Company receiverCompany, BigDecimal amount, Currency currency, LocalDate bankOrderDate, String receiverReference, String receiverLabel, Model origin) throws AxelorException {
        return this.createBankOrderLine(bankOrderFileFormat, receiverCompany, receiverCompany.getPartner(), receiverCompany.getDefaultBankDetails(), amount, currency, bankOrderDate, receiverReference, receiverLabel, origin);
    }

    public BankOrderLine createBankOrderLine(BankOrderFileFormat bankOrderFileFormat, Company receiverCompany, Partner partner, BankDetails bankDetails, BigDecimal amount, Currency currency, LocalDate bankOrderDate, String receiverReference, String receiverLabel, Model origin) throws AxelorException {
        BankOrderLine bankOrderLine = new BankOrderLine();
        bankOrderLine.setReceiverCompany(receiverCompany);
        bankOrderLine.setPartner(partner);
        bankOrderLine.setReceiverBankDetails(bankDetails);
        bankOrderLine.setBankOrderAmount(amount);
        if (bankOrderFileFormat.getIsMultiCurrency().booleanValue()) {
            bankOrderLine.setBankOrderCurrency(currency);
        }
        if (bankOrderFileFormat.getIsMultiDate().booleanValue()) {
            bankOrderLine.setBankOrderDate(bankOrderDate);
        }
        bankOrderLine.setReceiverReference(receiverReference);
        bankOrderLine.setReceiverLabel(receiverLabel);
        if (origin != null) {
            bankOrderLine.addBankOrderLineOriginListItem(this.bankOrderLineOriginService.createBankOrderLineOrigin(origin));
        }
        if (bankOrderFileFormat.getOrderFileFormatSelect().equals("pain.xxx.cfonb320.xct")) {
            bankOrderLine.setBankOrderEconomicReason(bankOrderFileFormat.getBankOrderEconomicReason());
            bankOrderLine.setReceiverCountry(bankOrderFileFormat.getReceiverCountry());
            if (bankDetails != null) {
                Bank bank = bankDetails.getBank();
                if (bank != null && bank.getCountry() != null) {
                    bankOrderLine.setReceiverCountry(bank.getCountry());
                }
            } else {
                throw new AxelorException((Model)((Object)bankOrderLine), 5, I18n.get((String)"Please fill the receiver bank details"));
            }
            bankOrderLine.setPaymentModeSelect(bankOrderFileFormat.getPaymentModeSelect());
            bankOrderLine.setFeesImputationModeSelect(bankOrderFileFormat.getFeesImputationModeSelect());
            bankOrderLine.setReceiverAddressStr(this.getReceiverAddress(partner));
        }
        return bankOrderLine;
    }

    @CallMethod
    public String getReceiverAddress(Partner partner) {
        Address receiverAddress = ((PartnerService)Beans.get(PartnerService.class)).getInvoicingAddress(partner);
        return receiverAddress != null ? receiverAddress.getFullName() : "";
    }

    public void checkPreconditions(BankOrderLine bankOrderLine) throws AxelorException {
        if (bankOrderLine.getBankOrder().getPartnerTypeSelect() == 4 && bankOrderLine.getReceiverCompany() == null) {
            throw new AxelorException((Model)((Object)bankOrderLine), 5, I18n.get((String)"Please select a company for the bank order lines inserted"));
        }
        if (bankOrderLine.getPartner() == null) {
            throw new AxelorException((Model)((Object)bankOrderLine), 5, I18n.get((String)"Please select a partner for the bank order lines inserted"));
        }
        if (bankOrderLine.getReceiverBankDetails() == null) {
            throw new AxelorException((Model)((Object)bankOrderLine), 5, I18n.get((String)"Please fill the receiver bank details"));
        }
        if (bankOrderLine.getBankOrderAmount().compareTo(BigDecimal.ZERO) <= 0) {
            throw new AxelorException((Model)((Object)bankOrderLine), 5, I18n.get((String)"Amount value of a bank order line is not valid"));
        }
    }

    public String createDomainForBankDetails(BankOrderLine bankOrderLine, BankOrder bankOrder) {
        String acceptedIdentifiers;
        String domain = "";
        String bankDetailsIds = "";
        if (bankOrderLine == null || bankOrder == null) {
            return domain;
        }
        if (bankOrder.getPartnerTypeSelect() == 4) {
            if (bankOrderLine.getReceiverCompany() != null) {
                bankDetailsIds = StringTool.getIdListString(bankOrderLine.getReceiverCompany().getBankDetailsList());
                if (bankOrderLine.getReceiverCompany().getDefaultBankDetails() != null) {
                    bankDetailsIds = bankDetailsIds + (bankDetailsIds.equals("") ? "" : ",");
                    bankDetailsIds = bankDetailsIds + bankOrderLine.getReceiverCompany().getDefaultBankDetails().getId().toString();
                }
            }
        } else if (bankOrderLine.getPartner() != null) {
            bankDetailsIds = StringTool.getIdListString(bankOrderLine.getPartner().getBankDetailsList());
        }
        if (bankDetailsIds.equals("")) {
            domain = "";
            return "";
        }
        domain = "self.id IN(" + bankDetailsIds + ")";
        domain = domain + " AND self.active = true";
        EbicsPartner ebicsPartner = (EbicsPartner)((Object)((EbicsPartnerRepository)((Object)Beans.get(EbicsPartnerRepository.class))).all().filter("? MEMBER OF self.bankDetailsSet", new Object[]{bankOrder.getSenderBankDetails()}).fetchOne());
        if (this.ebicsPartnerIsFiltering(ebicsPartner, bankOrder.getOrderTypeSelect())) {
            domain = domain + " AND self.id IN (" + StringTool.getIdListString(ebicsPartner.getReceiverBankDetailsSet()) + ")";
        }
        if (bankOrder.getBankOrderFileFormat() != null && (acceptedIdentifiers = bankOrder.getBankOrderFileFormat().getBankDetailsTypeSelect()) != null && !acceptedIdentifiers.equals("")) {
            domain = domain + " AND self.bank.bankDetailsTypeSelect IN (" + acceptedIdentifiers + ")";
        }
        Currency currency = bankOrder.getBankOrderCurrency();
        if (!bankOrder.getIsMultiCurrency().booleanValue() && currency != null && bankOrder.getPartnerTypeSelect() == 4) {
            String fileFormatCurrencyId = currency.getId().toString();
            domain = domain + " AND (self.currency IS NULL OR self.currency.id = " + fileFormatCurrencyId + ")";
        }
        return domain;
    }

    public BankDetails getDefaultBankDetails(BankOrderLine bankOrderLine, BankOrder bankOrder) {
        List bankDetailsList;
        BankDetails candidateBankDetails = null;
        if (bankOrder.getPartnerTypeSelect() == 4 && bankOrderLine.getReceiverCompany() != null) {
            candidateBankDetails = bankOrderLine.getReceiverCompany().getDefaultBankDetails();
            if (candidateBankDetails == null) {
                for (BankDetails bankDetails : bankOrderLine.getReceiverCompany().getBankDetailsList()) {
                    if (candidateBankDetails != null && bankDetails.getActive().booleanValue()) {
                        candidateBankDetails = null;
                        break;
                    }
                    if (!bankDetails.getActive().booleanValue()) continue;
                    candidateBankDetails = bankDetails;
                }
            }
        } else if (bankOrder.getPartnerTypeSelect() != 4 && bankOrderLine.getPartner() != null && (candidateBankDetails = this.bankDetailsRepo.findDefaultByPartner(bankOrderLine.getPartner())) == null && (bankDetailsList = this.bankDetailsRepo.findActivesByPartner(bankOrderLine.getPartner(), true).fetch()).size() == 1) {
            candidateBankDetails = (BankDetails)((Object)bankDetailsList.get(0));
        }
        try {
            this.checkBankDetails(candidateBankDetails, bankOrder);
        }
        catch (AxelorException e) {
            candidateBankDetails = null;
        }
        return candidateBankDetails;
    }

    public void checkBankDetails(BankDetails bankDetails, BankOrder bankOrder) throws AxelorException {
        if (bankDetails == null) {
            throw new AxelorException(5, I18n.get((String)"Please fill the receiver bank details"));
        }
        if (!bankDetails.getActive().booleanValue()) {
            throw new AxelorException(5, I18n.get((String)"The receiver bank details is inactive."));
        }
        EbicsPartner ebicsPartner = (EbicsPartner)((Object)((EbicsPartnerRepository)((Object)Beans.get(EbicsPartnerRepository.class))).all().filter("? MEMBER OF self.bankDetailsSet", new Object[]{bankOrder.getSenderBankDetails()}).fetchOne());
        if (this.ebicsPartnerIsFiltering(ebicsPartner, bankOrder.getOrderTypeSelect()) && !ebicsPartner.getReceiverBankDetailsSet().contains((Object)bankDetails)) {
            throw new AxelorException(5, I18n.get((String)"You cannot use this bank account because he is not authorized by the ebics partner."));
        }
        if (bankOrder.getBankOrderFileFormat() != null && !((BankOrderService)Beans.get(BankOrderService.class)).checkBankDetailsTypeCompatible(bankDetails, bankOrder.getBankOrderFileFormat())) {
            throw new AxelorException(5, I18n.get((String)"The receiver bank details type is not compatible with the accepted types in file format."));
        }
        if (!bankOrder.getIsMultiCurrency().booleanValue() && bankOrder.getBankOrderCurrency() != null && bankOrder.getPartnerTypeSelect() == 4 && !((BankOrderService)Beans.get(BankOrderService.class)).checkBankDetailsCurrencyCompatible(bankDetails, bankOrder)) {
            throw new AxelorException(5, I18n.get((String)"The receiver bank details currency is not compatible with the currency in bank order."));
        }
    }

    private boolean ebicsPartnerIsFiltering(EbicsPartner ebicsPartner, int orderType) {
        return ebicsPartner != null && ebicsPartner.getFilterReceiverBD() != false && ebicsPartner.getReceiverBankDetailsSet() != null && !ebicsPartner.getReceiverBankDetailsSet().isEmpty() && ebicsPartner.getOrderTypeSelect() == orderType;
    }

    public BigDecimal computeCompanyCurrencyAmount(BankOrder bankOrder, BankOrderLine bankOrderLine) throws AxelorException {
        LocalDate bankOrderDate = bankOrder.getBankOrderDate();
        if (bankOrder.getIsMultiDate().booleanValue()) {
            bankOrderDate = bankOrderLine.getBankOrderDate();
        }
        Currency bankOrderCurrency = bankOrder.getBankOrderCurrency();
        if (bankOrder.getIsMultiCurrency().booleanValue()) {
            bankOrderCurrency = bankOrderLine.getBankOrderCurrency();
        }
        return this.currencyService.getAmountCurrencyConvertedAtDate(bankOrderCurrency, bankOrder.getCompanyCurrency(), bankOrderLine.getBankOrderAmount(), bankOrderDate).setScale(2, RoundingMode.HALF_UP);
    }
}

