/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankorder;

import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.BankOrderFileFormat;
import com.axelor.apps.bankpayment.db.EbicsUser;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.exception.AxelorException;
import com.axelor.meta.schema.actions.ActionView;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;

public interface BankOrderService {
    public BigDecimal computeBankOrderTotalAmount(BankOrder var1) throws AxelorException;

    public BigDecimal computeCompanyCurrencyTotalAmount(BankOrder var1) throws AxelorException;

    public void updateTotalAmounts(BankOrder var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void confirm(BankOrder var1) throws AxelorException, JAXBException, IOException, DatatypeConfigurationException;

    @Transactional(rollbackOn={Exception.class})
    public void sign(BankOrder var1);

    @Transactional(rollbackOn={Exception.class})
    public void validate(BankOrder var1) throws JAXBException, IOException, AxelorException, DatatypeConfigurationException;

    public void realize(BankOrder var1) throws AxelorException;

    public File generateFile(BankOrder var1) throws JAXBException, IOException, AxelorException, DatatypeConfigurationException;

    @Transactional(rollbackOn={Exception.class})
    public BankOrder generateSequence(BankOrder var1) throws AxelorException;

    public void setSequenceOnBankOrderLines(BankOrder var1);

    public void checkLines(BankOrder var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void validatePayment(BankOrder var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void cancelPayment(BankOrder var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void cancelBankOrder(BankOrder var1) throws AxelorException;

    @Transactional
    public EbicsUser getDefaultEbicsUserFromBankDetails(BankDetails var1);

    public String createDomainForBankDetails(BankOrder var1);

    public BankDetails getDefaultBankDetails(BankOrder var1);

    public void checkBankDetails(BankDetails var1, BankOrder var2) throws AxelorException;

    public boolean checkBankDetailsTypeCompatible(BankDetails var1, BankOrderFileFormat var2);

    public boolean checkBankDetailsCurrencyCompatible(BankDetails var1, BankOrder var2);

    public void resetReceivers(BankOrder var1);

    public ActionView.ActionViewBuilder buildBankOrderLineView(String var1, String var2, String var3);

    public void setStatusToDraft(BankOrder var1);

    public void setStatusToRejected(BankOrder var1);
}

