/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankorder.file;

import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.BankOrderFileFormat;
import com.axelor.apps.bankpayment.db.BankOrderLine;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.tool.file.FileTool;
import com.axelor.apps.tool.xml.Marschaller;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BankOrderFileService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final String FILE_EXTENSION_XML = "xml";
    protected static final String FILE_EXTENSION_TXT = "txt";
    protected PaymentMode paymentMode;
    protected BankOrderFileFormat bankOrderFileFormat;
    protected LocalDate bankOrderDate;
    protected BankDetails senderBankDetails;
    protected Company senderCompany;
    protected Currency bankOrderCurrency;
    protected BigDecimal bankOrderTotalAmount;
    protected BigDecimal arithmeticTotal;
    protected int nbOfLines;
    protected LocalDateTime generationDateTime;
    protected String bankOrderSeq;
    protected boolean isMultiDates;
    protected boolean isMultiCurrencies;
    protected List<BankOrderLine> bankOrderLineList;
    protected Object fileToCreate;
    protected String context;
    protected String fileExtension;

    public BankOrderFileService(BankOrder bankOrder) {
        this.paymentMode = bankOrder.getPaymentMode();
        this.bankOrderFileFormat = bankOrder.getBankOrderFileFormat();
        this.bankOrderDate = bankOrder.getBankOrderDate();
        this.senderBankDetails = bankOrder.getSenderBankDetails();
        this.senderCompany = bankOrder.getSenderCompany();
        this.bankOrderCurrency = bankOrder.getBankOrderCurrency();
        this.bankOrderTotalAmount = bankOrder.getBankOrderTotalAmount();
        this.arithmeticTotal = bankOrder.getArithmeticTotal();
        this.nbOfLines = bankOrder.getNbOfLines();
        this.generationDateTime = bankOrder.getFileGenerationDateTime();
        this.bankOrderSeq = bankOrder.getBankOrderSeq();
        this.bankOrderLineList = bankOrder.getBankOrderLineList();
        this.isMultiDates = bankOrder.getIsMultiDate();
        this.isMultiCurrencies = bankOrder.getIsMultiCurrency();
    }

    protected String getSenderAddress() throws AxelorException {
        Address senderAddress = this.senderCompany.getAddress();
        if (senderAddress == null || Strings.isNullOrEmpty((String)senderAddress.getFullName())) {
            throw new AxelorException(5, I18n.get((String)"No address has been defined in the sender company %s"), new Object[]{this.senderCompany.getName()});
        }
        return senderAddress.getFullName();
    }

    protected String getFolderPath() throws AxelorException {
        String folderPath = this.paymentMode.getBankOrderExportFolderPath();
        if (Strings.isNullOrEmpty((String)folderPath)) {
            throw new AxelorException(5, I18n.get((String)"No folder path has been defined in the payment mode %s"), new Object[]{this.paymentMode.getName()});
        }
        return folderPath;
    }

    public File generateFile() throws JAXBException, IOException, AxelorException, DatatypeConfigurationException {
        switch (this.fileExtension) {
            case "xml": {
                return Marschaller.marschalFile((Object)this.fileToCreate, (String)this.context, (String)this.getFolderPath(), (String)this.computeFileName());
            }
            case "txt": {
                try {
                    return FileTool.writer((String)this.getFolderPath(), (String)this.computeFileName(), (List)((List)this.fileToCreate));
                }
                catch (IOException e) {
                    throw new AxelorException(e.getCause(), 4, I18n.get((String)"%s : Error detected during CFONB file's writing : %s"), new Object[]{I18n.get((String)"Warning !"), e});
                }
            }
        }
        throw new AxelorException(5, I18n.get((String)"Unknown format for file generation"), new Object[]{this.paymentMode.getName()});
    }

    public String computeFileName() {
        return String.format("%s%s.%s", this.bankOrderFileFormat.getOrderFileFormatSelect(), this.generationDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss")), this.fileExtension);
    }
}

