/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankorder.file.directdebit;

import com.axelor.apps.account.db.Umr;
import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.BankOrderLine;
import com.axelor.apps.bankpayment.service.bankorder.file.directdebit.BankOrderFile008Service;
import com.axelor.apps.bankpayment.service.config.BankPaymentConfigService;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.AccountIdentification4Choice;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.ActiveOrHistoricCurrencyAndAmount;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.BranchAndFinancialInstitutionIdentification4;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.CashAccount16;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.ChargeBearerType1Code;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.CustomerDirectDebitInitiationV02;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.DirectDebitTransaction6;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.DirectDebitTransactionInformation9;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.Document;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.FinancialInstitutionIdentification7;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.GenericFinancialIdentification1;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.GenericPersonIdentification1;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.GroupHeader39;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.LocalInstrument2Choice;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.MandateRelatedInformation6;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.ObjectFactory;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.Party6Choice;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.PartyIdentification32;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.PaymentIdentification1;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.PaymentInstructionInformation4;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.PaymentMethod2Code;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.PaymentTypeInformation20;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.PersonIdentification5;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.PersonIdentificationSchemeName1Choice;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.RemittanceInformation5;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.SequenceType1Code;
import com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02.ServiceLevel8Choice;
import com.axelor.apps.base.db.Bank;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

public class BankOrderFile00800102Service
extends BankOrderFile008Service {
    protected ObjectFactory factory;
    protected String sepaType;

    @Inject
    public BankOrderFile00800102Service(BankOrder bankOrder, String sepaType) {
        super(bankOrder);
        this.context = "com.axelor.apps.bankpayment.xsd.sepa.pain_008_001_02";
        this.factory = new ObjectFactory();
        this.sepaType = sepaType;
    }

    @Override
    public File generateFile() throws JAXBException, IOException, AxelorException, DatatypeConfigurationException {
        PartyIdentification32 creditor = this.factory.createPartyIdentification32();
        creditor.setNm(this.senderBankDetails.getOwnerName());
        Document document = this.factory.createDocument();
        CustomerDirectDebitInitiationV02 customerDirectDebitInitiationV02 = this.factory.createCustomerDirectDebitInitiationV02();
        document.setCstmrDrctDbtInitn(customerDirectDebitInitiationV02);
        GroupHeader39 groupHeader = this.factory.createGroupHeader39();
        this.createGrpHdr(groupHeader, creditor);
        customerDirectDebitInitiationV02.setGrpHdr(groupHeader);
        this.createPmtInf(customerDirectDebitInitiationV02.getPmtInf(), creditor);
        this.fileToCreate = this.factory.createDocument(document);
        return super.generateFile();
    }

    protected void createGrpHdr(GroupHeader39 groupHeader, PartyIdentification32 creditor) throws DatatypeConfigurationException {
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        groupHeader.setMsgId(this.bankOrderSeq);
        groupHeader.setCreDtTm(datatypeFactory.newXMLGregorianCalendar(this.generationDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"))));
        groupHeader.setNbOfTxs(Integer.toString(this.nbOfLines));
        groupHeader.setCtrlSum(this.arithmeticTotal);
        groupHeader.setInitgPty(creditor);
    }

    protected void createPmtInf(List<PaymentInstructionInformation4> paymentInstructionInformationList, PartyIdentification32 creditor) throws AxelorException, DatatypeConfigurationException {
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        PaymentInstructionInformation4 paymentInstructionInformation4 = this.factory.createPaymentInstructionInformation4();
        paymentInstructionInformationList.add(paymentInstructionInformation4);
        paymentInstructionInformation4.setPmtInfId(this.bankOrderSeq);
        paymentInstructionInformation4.setPmtMtd(PaymentMethod2Code.DD);
        paymentInstructionInformation4.setBtchBookg(true);
        paymentInstructionInformation4.setNbOfTxs(Integer.toString(this.nbOfLines));
        paymentInstructionInformation4.setCtrlSum(this.arithmeticTotal);
        PaymentTypeInformation20 paymentTypeInformation20 = this.factory.createPaymentTypeInformation20();
        paymentInstructionInformation4.setPmtTpInf(paymentTypeInformation20);
        ServiceLevel8Choice serviceLevel8Choice = this.factory.createServiceLevel8Choice();
        paymentTypeInformation20.setSvcLvl(serviceLevel8Choice);
        serviceLevel8Choice.setCd("SEPA");
        LocalInstrument2Choice localInstrument2Choice = this.factory.createLocalInstrument2Choice();
        switch (this.sepaType) {
            case "CORE": {
                localInstrument2Choice.setCd("CORE");
                break;
            }
            case "SBB": {
                localInstrument2Choice.setCd("SBB");
                break;
            }
            default: {
                throw new AxelorException(4, I18n.get((String)"Unknown SEPA type for file generation"));
            }
        }
        paymentTypeInformation20.setLclInstrm(localInstrument2Choice);
        paymentTypeInformation20.setSeqTp(SequenceType1Code.FRST);
        paymentInstructionInformation4.setReqdColltnDt(datatypeFactory.newXMLGregorianCalendar(this.bankOrderDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))));
        paymentInstructionInformation4.setCdtr(creditor);
        CashAccount16 cashAccount16 = this.factory.createCashAccount16();
        AccountIdentification4Choice accountIdentification4Choice = this.factory.createAccountIdentification4Choice();
        accountIdentification4Choice.setIBAN(this.senderBankDetails.getIban());
        cashAccount16.setId(accountIdentification4Choice);
        cashAccount16.setCcy("EUR");
        paymentInstructionInformation4.setCdtrAcct(cashAccount16);
        FinancialInstitutionIdentification7 financialInstitutionIdentification7 = this.factory.createFinancialInstitutionIdentification7();
        this.fillBic(financialInstitutionIdentification7, this.senderBankDetails.getBank());
        BranchAndFinancialInstitutionIdentification4 branchAndFinancialInstitutionIdentification4 = this.factory.createBranchAndFinancialInstitutionIdentification4();
        branchAndFinancialInstitutionIdentification4.setFinInstnId(financialInstitutionIdentification7);
        paymentInstructionInformation4.setCdtrAgt(branchAndFinancialInstitutionIdentification4);
        paymentInstructionInformation4.setChrgBr(ChargeBearerType1Code.SLEV);
        this.createDrctDbtTxInf(paymentInstructionInformation4.getDrctDbtTxInf(), creditor);
    }

    protected void createDrctDbtTxInf(List<DirectDebitTransactionInformation9> directDebitTransactionInformation9List, PartyIdentification32 creditor) throws DatatypeConfigurationException, AxelorException {
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        for (BankOrderLine bankOrderLine : this.bankOrderLineList) {
            BankDetails receiverBankDetails = bankOrderLine.getReceiverBankDetails();
            Umr receiverUmr = bankOrderLine.getPartner().getActiveUmr();
            if (receiverUmr == null) {
                throw new AxelorException(4, I18n.get((String)"Please add an Active UMR to the partner."));
            }
            DirectDebitTransactionInformation9 directDebitTransactionInformation9 = this.factory.createDirectDebitTransactionInformation9();
            directDebitTransactionInformation9List.add(directDebitTransactionInformation9);
            PaymentIdentification1 paymentIdentification1 = this.factory.createPaymentIdentification1();
            directDebitTransactionInformation9.setPmtId(paymentIdentification1);
            paymentIdentification1.setEndToEndId(bankOrderLine.getSequence());
            ActiveOrHistoricCurrencyAndAmount activeOrHistoricCurrencyAndAmount = this.factory.createActiveOrHistoricCurrencyAndAmount();
            activeOrHistoricCurrencyAndAmount.setCcy("EUR");
            activeOrHistoricCurrencyAndAmount.setValue(bankOrderLine.getBankOrderAmount());
            directDebitTransactionInformation9.setInstdAmt(activeOrHistoricCurrencyAndAmount);
            DirectDebitTransaction6 directDebitTransaction6 = this.factory.createDirectDebitTransaction6();
            directDebitTransactionInformation9.setDrctDbtTx(directDebitTransaction6);
            MandateRelatedInformation6 mandateRelatedInformation6 = this.factory.createMandateRelatedInformation6();
            directDebitTransaction6.setMndtRltdInf(mandateRelatedInformation6);
            mandateRelatedInformation6.setMndtId(receiverUmr.getUmrNumber());
            mandateRelatedInformation6.setDtOfSgntr(datatypeFactory.newXMLGregorianCalendar(receiverUmr.getMandateSignatureDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))));
            PartyIdentification32 creditorSchemeId = this.factory.createPartyIdentification32();
            directDebitTransaction6.setCdtrSchmeId(creditorSchemeId);
            Party6Choice party6Choice = this.factory.createParty6Choice();
            creditorSchemeId.setId(party6Choice);
            PersonIdentification5 personIdentification5 = this.factory.createPersonIdentification5();
            party6Choice.setPrvtId(personIdentification5);
            GenericPersonIdentification1 genericPersonIdentification1 = this.factory.createGenericPersonIdentification1();
            personIdentification5.getOthr().add(genericPersonIdentification1);
            genericPersonIdentification1.setId(((BankPaymentConfigService)Beans.get(BankPaymentConfigService.class)).getIcsNumber(this.senderCompany.getBankPaymentConfig()));
            PersonIdentificationSchemeName1Choice personIdentificationSchemeName1Choice = this.factory.createPersonIdentificationSchemeName1Choice();
            genericPersonIdentification1.setSchmeNm(personIdentificationSchemeName1Choice);
            personIdentificationSchemeName1Choice.setPrtry("SEPA");
            BranchAndFinancialInstitutionIdentification4 branchAndFinancialInstitutionIdentification4 = this.factory.createBranchAndFinancialInstitutionIdentification4();
            FinancialInstitutionIdentification7 financialInstitutionIdentification7 = this.factory.createFinancialInstitutionIdentification7();
            this.fillBic(financialInstitutionIdentification7, receiverBankDetails.getBank());
            branchAndFinancialInstitutionIdentification4.setFinInstnId(financialInstitutionIdentification7);
            directDebitTransactionInformation9.setDbtrAgt(branchAndFinancialInstitutionIdentification4);
            PartyIdentification32 debtor = this.factory.createPartyIdentification32();
            debtor.setNm(receiverBankDetails.getOwnerName());
            directDebitTransactionInformation9.setDbtr(debtor);
            AccountIdentification4Choice accountIdentification4Choice = this.factory.createAccountIdentification4Choice();
            accountIdentification4Choice.setIBAN(receiverBankDetails.getIban());
            CashAccount16 cashAccount16 = this.factory.createCashAccount16();
            cashAccount16.setId(accountIdentification4Choice);
            directDebitTransactionInformation9.setDbtrAcct(cashAccount16);
            RemittanceInformation5 remittanceInformation5 = this.factory.createRemittanceInformation5();
            directDebitTransactionInformation9.setRmtInf(remittanceInformation5);
            remittanceInformation5.getUstrd().add(bankOrderLine.getReceiverReference());
        }
    }

    protected void fillBic(FinancialInstitutionIdentification7 finInstnId, Bank bank) {
        if (this.bankOrderFileFormat.getIbanOnly().booleanValue() || bank == null || Strings.isNullOrEmpty((String)bank.getCode())) {
            GenericFinancialIdentification1 genFinId = new GenericFinancialIdentification1();
            genFinId.setId("NOTPROVIDED");
            finInstnId.setOthr(genFinId);
        } else {
            finInstnId.setBIC(bank.getCode());
        }
    }
}

