/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankorder.file.transfer;

import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.BankOrderLine;
import com.axelor.apps.bankpayment.service.bankorder.file.BankOrderFileService;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.AccountIdentification3Choice;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.AmountType2Choice;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.BranchAndFinancialInstitutionIdentification3;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.CashAccount7;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.CreditTransferTransactionInformation1;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.CurrencyAndAmount;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.Document;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.FinancialInstitutionIdentification5Choice;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.GenericIdentification3;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.GroupHeader1;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.Grouping1Code;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.ObjectFactory;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.Pain00100102;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.PartyIdentification8;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.PaymentIdentification1;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.PaymentInstructionInformation1;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.PaymentMethod3Code;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.PaymentTypeInformation1;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.RemittanceInformation1;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.ServiceLevel1Code;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02.ServiceLevel2Choice;
import com.axelor.apps.base.db.Bank;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.exception.AxelorException;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

public class BankOrderFile00100102Service
extends BankOrderFileService {
    protected static final String BIC_NOT_PROVIDED = "NOTPROVIDED";

    @Inject
    public BankOrderFile00100102Service(BankOrder bankOrder) {
        super(bankOrder);
        this.context = "com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_02";
        this.fileExtension = "xml";
    }

    @Override
    public File generateFile() throws JAXBException, IOException, AxelorException, DatatypeConfigurationException {
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        ObjectFactory factory = new ObjectFactory();
        ServiceLevel2Choice svcLvl = factory.createServiceLevel2Choice();
        svcLvl.setCd(ServiceLevel1Code.SEPA);
        PaymentTypeInformation1 pmtTpInf = factory.createPaymentTypeInformation1();
        pmtTpInf.setSvcLvl(svcLvl);
        PartyIdentification8 dbtr = factory.createPartyIdentification8();
        dbtr.setNm(this.senderBankDetails.getOwnerName());
        AccountIdentification3Choice iban = factory.createAccountIdentification3Choice();
        iban.setIBAN(this.senderBankDetails.getIban());
        CashAccount7 dbtrAcct = factory.createCashAccount7();
        dbtrAcct.setId(iban);
        FinancialInstitutionIdentification5Choice finInstnId = factory.createFinancialInstitutionIdentification5Choice();
        this.fillBic(finInstnId, this.senderBankDetails.getBank());
        BranchAndFinancialInstitutionIdentification3 dbtrAgt = factory.createBranchAndFinancialInstitutionIdentification3();
        dbtrAgt.setFinInstnId(finInstnId);
        PaymentInstructionInformation1 pmtInf = factory.createPaymentInstructionInformation1();
        pmtInf.setPmtInfId(this.bankOrderSeq);
        pmtInf.setPmtMtd(PaymentMethod3Code.TRF);
        pmtInf.setPmtTpInf(pmtTpInf);
        pmtInf.setReqdExctnDt(datatypeFactory.newXMLGregorianCalendar(this.bankOrderDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))));
        pmtInf.setDbtr(dbtr);
        pmtInf.setDbtrAcct(dbtrAcct);
        pmtInf.setDbtrAgt(dbtrAgt);
        CreditTransferTransactionInformation1 cdtTrfTxInf = null;
        PaymentIdentification1 pmtId = null;
        AmountType2Choice amt = null;
        CurrencyAndAmount instdAmt = null;
        PartyIdentification8 cbtr = null;
        CashAccount7 cbtrAcct = null;
        BranchAndFinancialInstitutionIdentification3 cbtrAgt = null;
        RemittanceInformation1 rmtInf = null;
        for (BankOrderLine bankOrderLine : this.bankOrderLineList) {
            BankDetails receiverBankDetails = bankOrderLine.getReceiverBankDetails();
            pmtId = factory.createPaymentIdentification1();
            pmtId.setEndToEndId(bankOrderLine.getSequence());
            instdAmt = factory.createCurrencyAndAmount();
            instdAmt.setCcy(this.bankOrderCurrency.getCode());
            instdAmt.setValue(bankOrderLine.getBankOrderAmount());
            amt = factory.createAmountType2Choice();
            amt.setInstdAmt(instdAmt);
            cbtr = factory.createPartyIdentification8();
            cbtr.setNm(receiverBankDetails.getOwnerName());
            iban = factory.createAccountIdentification3Choice();
            iban.setIBAN(receiverBankDetails.getIban());
            cbtrAcct = factory.createCashAccount7();
            cbtrAcct.setId(iban);
            finInstnId = factory.createFinancialInstitutionIdentification5Choice();
            this.fillBic(finInstnId, receiverBankDetails.getBank());
            cbtrAgt = factory.createBranchAndFinancialInstitutionIdentification3();
            cbtrAgt.setFinInstnId(finInstnId);
            rmtInf = factory.createRemittanceInformation1();
            String ustrd = "";
            if (!Strings.isNullOrEmpty((String)bankOrderLine.getReceiverReference())) {
                ustrd = ustrd + bankOrderLine.getReceiverReference();
            }
            if (!Strings.isNullOrEmpty((String)bankOrderLine.getReceiverLabel())) {
                if (!Strings.isNullOrEmpty((String)ustrd)) {
                    ustrd = ustrd + " - ";
                }
                ustrd = ustrd + bankOrderLine.getReceiverLabel();
            }
            if (!Strings.isNullOrEmpty((String)ustrd)) {
                rmtInf.getUstrd().add(ustrd);
            }
            cdtTrfTxInf = factory.createCreditTransferTransactionInformation1();
            cdtTrfTxInf.setPmtId(pmtId);
            cdtTrfTxInf.setAmt(amt);
            cdtTrfTxInf.setCdtr(cbtr);
            cdtTrfTxInf.setCdtrAcct(cbtrAcct);
            cdtTrfTxInf.setCdtrAgt(cbtrAgt);
            cdtTrfTxInf.setRmtInf(rmtInf);
            pmtInf.getCdtTrfTxInf().add(cdtTrfTxInf);
        }
        GroupHeader1 grpHdr = factory.createGroupHeader1();
        grpHdr.setMsgId(this.bankOrderSeq);
        grpHdr.setCreDtTm(datatypeFactory.newXMLGregorianCalendar(this.generationDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"))));
        grpHdr.setNbOfTxs(Integer.toString(this.nbOfLines));
        grpHdr.setCtrlSum(this.arithmeticTotal);
        grpHdr.setGrpg(Grouping1Code.MIXD);
        grpHdr.setInitgPty(dbtr);
        Pain00100102 pain00100102 = factory.createPain00100102();
        pain00100102.setGrpHdr(grpHdr);
        pain00100102.getPmtInf().add(pmtInf);
        Document xml = factory.createDocument();
        xml.setPain00100102(pain00100102);
        this.fileToCreate = factory.createDocument(xml);
        return super.generateFile();
    }

    protected void fillBic(FinancialInstitutionIdentification5Choice finInstnId, Bank bank) {
        if (this.bankOrderFileFormat.getIbanOnly().booleanValue() || bank == null || Strings.isNullOrEmpty((String)bank.getCode())) {
            GenericIdentification3 genId = new GenericIdentification3();
            genId.setId(BIC_NOT_PROVIDED);
            finInstnId.setPrtryId(genId);
        } else {
            finInstnId.setBIC(bank.getCode());
        }
    }
}

