/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankorder.file.transfer;

import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.BankOrderLine;
import com.axelor.apps.bankpayment.service.bankorder.file.BankOrderFileService;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.AccountIdentification4Choice;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.ActiveOrHistoricCurrencyAndAmount;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.AmountType3Choice;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.BranchAndFinancialInstitutionIdentification4;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.CashAccount16;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.CreditTransferTransactionInformation10;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.CustomerCreditTransferInitiationV03;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.Document;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.FinancialInstitutionIdentification7;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.GenericFinancialIdentification1;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.GroupHeader32;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.ObjectFactory;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.PartyIdentification32;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.PaymentIdentification1;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.PaymentInstructionInformation3;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.PaymentMethod3Code;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.PaymentTypeInformation19;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.RemittanceInformation5;
import com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03.ServiceLevel8Choice;
import com.axelor.apps.base.db.Bank;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.exception.AxelorException;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

public class BankOrderFile00100103Service
extends BankOrderFileService {
    protected static final String BIC_NOT_PROVIDED = "NOTPROVIDED";

    @Inject
    public BankOrderFile00100103Service(BankOrder bankOrder) {
        super(bankOrder);
        this.context = "com.axelor.apps.bankpayment.xsd.sepa.pain_001_001_03";
        this.fileExtension = "xml";
    }

    @Override
    public File generateFile() throws JAXBException, IOException, AxelorException, DatatypeConfigurationException {
        DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();
        ObjectFactory factory = new ObjectFactory();
        ServiceLevel8Choice svcLvl = factory.createServiceLevel8Choice();
        svcLvl.setCd("SEPA");
        PaymentTypeInformation19 pmtTpInf = factory.createPaymentTypeInformation19();
        pmtTpInf.setSvcLvl(svcLvl);
        PartyIdentification32 dbtr = factory.createPartyIdentification32();
        dbtr.setNm(this.senderBankDetails.getOwnerName());
        AccountIdentification4Choice iban = factory.createAccountIdentification4Choice();
        iban.setIBAN(this.senderBankDetails.getIban());
        CashAccount16 dbtrAcct = factory.createCashAccount16();
        dbtrAcct.setId(iban);
        FinancialInstitutionIdentification7 finInstnId = factory.createFinancialInstitutionIdentification7();
        this.fillBic(finInstnId, this.senderBankDetails.getBank());
        BranchAndFinancialInstitutionIdentification4 dbtrAgt = factory.createBranchAndFinancialInstitutionIdentification4();
        dbtrAgt.setFinInstnId(finInstnId);
        PaymentInstructionInformation3 pmtInf = factory.createPaymentInstructionInformation3();
        pmtInf.setPmtInfId(this.bankOrderSeq);
        pmtInf.setPmtMtd(PaymentMethod3Code.TRF);
        pmtInf.setPmtTpInf(pmtTpInf);
        pmtInf.setReqdExctnDt(datatypeFactory.newXMLGregorianCalendar(this.bankOrderDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))));
        pmtInf.setDbtr(dbtr);
        pmtInf.setDbtrAcct(dbtrAcct);
        pmtInf.setDbtrAgt(dbtrAgt);
        CreditTransferTransactionInformation10 cdtTrfTxInf = null;
        PaymentIdentification1 pmtId = null;
        AmountType3Choice amt = null;
        ActiveOrHistoricCurrencyAndAmount instdAmt = null;
        PartyIdentification32 cbtr = null;
        CashAccount16 cbtrAcct = null;
        BranchAndFinancialInstitutionIdentification4 cbtrAgt = null;
        RemittanceInformation5 rmtInf = null;
        for (BankOrderLine bankOrderLine : this.bankOrderLineList) {
            BankDetails receiverBankDetails = bankOrderLine.getReceiverBankDetails();
            pmtId = factory.createPaymentIdentification1();
            pmtId.setEndToEndId(bankOrderLine.getSequence());
            instdAmt = factory.createActiveOrHistoricCurrencyAndAmount();
            instdAmt.setCcy(this.bankOrderCurrency.getCode());
            instdAmt.setValue(bankOrderLine.getBankOrderAmount());
            amt = factory.createAmountType3Choice();
            amt.setInstdAmt(instdAmt);
            cbtr = factory.createPartyIdentification32();
            cbtr.setNm(receiverBankDetails.getOwnerName());
            iban = factory.createAccountIdentification4Choice();
            iban.setIBAN(receiverBankDetails.getIban());
            cbtrAcct = factory.createCashAccount16();
            cbtrAcct.setId(iban);
            finInstnId = factory.createFinancialInstitutionIdentification7();
            this.fillBic(finInstnId, receiverBankDetails.getBank());
            cbtrAgt = factory.createBranchAndFinancialInstitutionIdentification4();
            cbtrAgt.setFinInstnId(finInstnId);
            rmtInf = factory.createRemittanceInformation5();
            String ustrd = "";
            if (!Strings.isNullOrEmpty((String)bankOrderLine.getReceiverReference())) {
                ustrd = ustrd + bankOrderLine.getReceiverReference();
            }
            if (!Strings.isNullOrEmpty((String)bankOrderLine.getReceiverLabel())) {
                if (!Strings.isNullOrEmpty((String)ustrd)) {
                    ustrd = ustrd + " - ";
                }
                ustrd = ustrd + bankOrderLine.getReceiverLabel();
            }
            if (!Strings.isNullOrEmpty((String)ustrd)) {
                rmtInf.getUstrd().add(ustrd);
            }
            cdtTrfTxInf = factory.createCreditTransferTransactionInformation10();
            cdtTrfTxInf.setPmtId(pmtId);
            cdtTrfTxInf.setAmt(amt);
            cdtTrfTxInf.setCdtr(cbtr);
            cdtTrfTxInf.setCdtrAcct(cbtrAcct);
            cdtTrfTxInf.setCdtrAgt(cbtrAgt);
            cdtTrfTxInf.setRmtInf(rmtInf);
            pmtInf.getCdtTrfTxInf().add(cdtTrfTxInf);
        }
        GroupHeader32 grpHdr = factory.createGroupHeader32();
        grpHdr.setMsgId(this.bankOrderSeq);
        grpHdr.setCreDtTm(datatypeFactory.newXMLGregorianCalendar(this.generationDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"))));
        grpHdr.setNbOfTxs(Integer.toString(this.nbOfLines));
        grpHdr.setCtrlSum(this.arithmeticTotal);
        grpHdr.setInitgPty(dbtr);
        CustomerCreditTransferInitiationV03 customerCreditTransferInitiationV03 = factory.createCustomerCreditTransferInitiationV03();
        customerCreditTransferInitiationV03.setGrpHdr(grpHdr);
        customerCreditTransferInitiationV03.getPmtInf().add(pmtInf);
        Document xml = factory.createDocument();
        xml.setCstmrCdtTrfInitn(customerCreditTransferInitiationV03);
        this.fileToCreate = factory.createDocument(xml);
        return super.generateFile();
    }

    protected void fillBic(FinancialInstitutionIdentification7 finInstnId, Bank bank) {
        if (this.bankOrderFileFormat.getIbanOnly().booleanValue() || bank == null || Strings.isNullOrEmpty((String)bank.getCode())) {
            GenericFinancialIdentification1 genFinId = new GenericFinancialIdentification1();
            genFinId.setId(BIC_NOT_PROVIDED);
            finInstnId.setOthr(genFinId);
        } else {
            finInstnId.setBIC(bank.getCode());
        }
    }
}

