/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankorder.file.transfer;

import com.axelor.apps.bankpayment.db.BankOrder;
import com.axelor.apps.bankpayment.db.BankOrderEconomicReason;
import com.axelor.apps.bankpayment.db.BankOrderFileFormatCountry;
import com.axelor.apps.bankpayment.db.BankOrderLine;
import com.axelor.apps.bankpayment.service.bankorder.file.BankOrderFileService;
import com.axelor.apps.bankpayment.service.cfonb.CfonbToolService;
import com.axelor.apps.base.db.Bank;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Country;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.tool.StringTool;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;

public class BankOrderFileAFB320XCTService
extends BankOrderFileService {
    protected String registrationCode;
    protected String senderAddress;
    protected CfonbToolService cfonbToolService;
    protected PartnerService partnerService = (PartnerService)Beans.get(PartnerService.class);
    protected int sequence = 1;
    protected static final int NB_CHAR_PER_LINE = 320;
    protected Currency senderCurrency;
    protected String qualityOfAmount;
    protected static final String OPERATION_CODE_PI = "PI";
    protected static final String OPERATION_CODE_RF = "RF";
    protected static final String OPERATION_CODE_VF = "VF";

    @Inject
    public BankOrderFileAFB320XCTService(BankOrder bankOrder) throws AxelorException {
        super(bankOrder);
        this.registrationCode = this.partnerService.getSIRENNumber(this.senderCompany.getPartner());
        this.senderAddress = this.getSenderAddress();
        this.cfonbToolService = (CfonbToolService)Beans.get(CfonbToolService.class);
        this.fileExtension = "txt";
        this.senderCurrency = this.senderBankDetails.getCurrency();
        this.qualityOfAmount = this.bankOrderFileFormat.getQualifyingOfAmountSelect();
    }

    @Override
    public File generateFile() throws JAXBException, IOException, AxelorException, DatatypeConfigurationException {
        ArrayList records = Lists.newArrayList();
        records.add(this.createSenderRecord());
        for (BankOrderLine bankOrderLine : this.bankOrderLineList) {
            records.add(this.createDetailRecord(bankOrderLine));
            if (bankOrderLine.getPaymentModeSelect() == 0) {
                records.add(this.createDependentReceiverBankRecord(bankOrderLine));
            }
            if (!this.useOptionnalFurtherInformationRecord(bankOrderLine)) continue;
            records.add(this.createOptionnalFurtherInformationRecord(bankOrderLine));
        }
        records.add(this.createTotalRecord());
        this.fileToCreate = records;
        return super.generateFile();
    }

    protected boolean useOptionnalFurtherInformationRecord(BankOrderLine bankOrderLine) {
        return !Strings.isNullOrEmpty((String)bankOrderLine.getPaymentReasonLine1()) || !Strings.isNullOrEmpty((String)bankOrderLine.getPaymentReasonLine2()) || !Strings.isNullOrEmpty((String)bankOrderLine.getPaymentReasonLine3()) || !Strings.isNullOrEmpty((String)bankOrderLine.getPaymentReasonLine4());
    }

    protected String createSenderRecord() throws AxelorException {
        try {
            Bank senderBank = this.senderBankDetails.getBank();
            String string = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            String senderRecord = this.cfonbToolService.createZone("1", "03", string, "N", 2);
            senderRecord = senderRecord + this.cfonbToolService.createZone("2", OPERATION_CODE_PI, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 2);
            StringBuilder stringBuilder = new StringBuilder().append(senderRecord);
            String string2 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            senderRecord = stringBuilder.append(this.cfonbToolService.createZone("3", this.sequence++, string2, "N", 6)).toString();
            StringBuilder stringBuilder2 = new StringBuilder().append(senderRecord);
            String string3 = I18n.get((String)"4 - Generation date");
            String string4 = this.generationDateTime.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            String string5 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            senderRecord = stringBuilder2.append(this.cfonbToolService.createZone(string3, string4, string5, "N", 8)).toString();
            senderRecord = senderRecord + this.cfonbToolService.createZone(I18n.get((String)"5 - Sender company"), this.senderCompany.getName(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 35);
            senderRecord = senderRecord + this.cfonbToolService.createZone(I18n.get((String)"6 - Sender address"), this.senderAddress, this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 105);
            senderRecord = senderRecord + this.cfonbToolService.createZone(I18n.get((String)"7 - Registration code"), this.registrationCode, this.cfonbToolService.STATUS_DEPENDENT, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 14);
            senderRecord = senderRecord + this.cfonbToolService.createZone(I18n.get((String)"8 - Sequence"), this.bankOrderSeq, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 16);
            senderRecord = senderRecord + this.cfonbToolService.createZone("9", "", this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 11);
            StringBuilder stringBuilder3 = new StringBuilder().append(senderRecord);
            String string6 = I18n.get((String)"10 - Sender bank details type");
            int n = senderBank.getBankDetailsTypeSelect();
            String string7 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            senderRecord = stringBuilder3.append(this.cfonbToolService.createZone(string6, n, string7, "N", 1)).toString();
            senderRecord = senderRecord + this.cfonbToolService.createZone(I18n.get((String)"11 - Sender bank details IBAN"), this.getIban(this.senderBankDetails), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 34);
            if (this.senderCurrency == null) {
                throw new AxelorException(1, I18n.get((String)"Please set a currency in the sender bank details : %s."), new Object[]{this.senderCompany.getName()});
            }
            senderRecord = senderRecord + this.cfonbToolService.createZone(I18n.get((String)"12 - Bank order currency"), this.senderCurrency.getCode(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 3);
            senderRecord = senderRecord + this.cfonbToolService.createZone("13", "", this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 16);
            senderRecord = senderRecord + this.cfonbToolService.createZone(I18n.get((String)"14 - Sender bank details type"), senderBank.getBankDetailsTypeSelect(), this.cfonbToolService.STATUS_DEPENDENT, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 1);
            senderRecord = senderRecord + this.cfonbToolService.createZone(I18n.get((String)"15 - Sender bank details IBAN"), this.getIban(this.senderBankDetails), this.cfonbToolService.STATUS_DEPENDENT, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 34);
            senderRecord = senderRecord + this.cfonbToolService.createZone(I18n.get((String)"16 - Bank order currency"), this.senderCurrency.getCode(), this.cfonbToolService.STATUS_DEPENDENT, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 3);
            StringBuilder stringBuilder4 = new StringBuilder().append(senderRecord);
            this.cfonbToolService.getClass();
            senderRecord = stringBuilder4.append(this.cfonbToolService.createZone("17-1", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 4)).toString();
            StringBuilder stringBuilder5 = new StringBuilder().append(senderRecord);
            this.cfonbToolService.getClass();
            senderRecord = stringBuilder5.append(this.cfonbToolService.createZone("17-2", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 1)).toString();
            senderRecord = senderRecord + this.cfonbToolService.createZone(I18n.get((String)"17-3 - File format qualifying date"), this.bankOrderFileFormat.getQualifyingOfDate(), this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 3);
            StringBuilder stringBuilder6 = new StringBuilder().append(senderRecord);
            this.cfonbToolService.getClass();
            senderRecord = stringBuilder6.append(this.cfonbToolService.createZone("17-4", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 8)).toString();
            senderRecord = senderRecord + this.cfonbToolService.createZone(I18n.get((String)"18 - Order debit type index"), this.bankOrderFileFormat.getOrderDebitTypeSelect(), this.cfonbToolService.STATUS_DEPENDENT, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 1);
            senderRecord = senderRecord + this.cfonbToolService.createZone(I18n.get((String)"19 - Order index type"), this.getOrderIndexType(this.isMultiDates, this.isMultiCurrencies), this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 1);
            if (!this.isMultiDates) {
                StringBuilder stringBuilder7 = new StringBuilder().append(senderRecord);
                String string8 = I18n.get((String)"20 - Bank order date");
                String string9 = this.bankOrderDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
                String string10 = this.cfonbToolService.STATUS_MANDATORY;
                this.cfonbToolService.getClass();
                senderRecord = stringBuilder7.append(this.cfonbToolService.createZone(string8, string9, string10, "N", 8)).toString();
            } else {
                StringBuilder stringBuilder8 = new StringBuilder().append(senderRecord);
                this.cfonbToolService.getClass();
                this.cfonbToolService.getClass();
                senderRecord = stringBuilder8.append(this.cfonbToolService.createZone("20", "", "N", "N", 8)).toString();
            }
            if (!this.isMultiCurrencies) {
                senderRecord = senderRecord + this.cfonbToolService.createZone(I18n.get((String)"21 - Currency"), this.bankOrderCurrency.getCode(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 3);
            } else {
                StringBuilder stringBuilder9 = new StringBuilder().append(senderRecord);
                this.cfonbToolService.getClass();
                senderRecord = stringBuilder9.append(this.cfonbToolService.createZone("21", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 3)).toString();
            }
            this.cfonbToolService.toUpperCase(senderRecord);
            this.cfonbToolService.testLength(senderRecord, 320);
            return senderRecord;
        }
        catch (Exception e) {
            throw new AxelorException((Throwable)e, (Model)((Object)this.senderBankDetails), 1, I18n.get((String)"Anomaly has been detected during file generation for the sender record of the bank order %s") + ": " + e.getMessage(), new Object[]{this.bankOrderSeq});
        }
    }

    public String getIban(BankDetails bankDetails) throws AxelorException {
        String iban = bankDetails.getIban();
        if (Strings.isNullOrEmpty((String)iban)) {
            throw new AxelorException((Model)((Object)bankDetails), 1, I18n.get((String)"The Iban is mandatory for the partner %s, bank order %s"), new Object[]{bankDetails.getOwnerName(), this.bankOrderSeq});
        }
        switch (bankDetails.getBank().getBankDetailsTypeSelect()) {
            case 1: {
                return StringTool.fillStringRight((String)bankDetails.getIban(), (char)' ', (int)34);
            }
            case 2: {
                return StringTool.fillStringRight((String)(StringTool.fillString((char)' ', (int)4) + bankDetails.getIban()), (char)' ', (int)34);
            }
            case 0: {
                return StringTool.fillStringRight((String)(StringTool.fillString((char)' ', (int)4) + bankDetails.getIban()), (char)' ', (int)34);
            }
        }
        return StringTool.fillStringRight((String)bankDetails.getIban(), (char)' ', (int)34);
    }

    protected int getOrderIndexType(boolean isMultiDates, boolean isMultiCurrencies) {
        int orderIndexType = 1;
        if (isMultiDates) {
            orderIndexType += 2;
        }
        if (isMultiCurrencies) {
            ++orderIndexType;
        }
        return orderIndexType;
    }

    protected String createDetailRecord(BankOrderLine bankOrderLine) throws AxelorException {
        try {
            String qualifyngOfAmountStr;
            BankDetails receiverBankDetails = bankOrderLine.getReceiverBankDetails();
            String string = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            String detailRecord = this.cfonbToolService.createZone("1", "04", string, "N", 2);
            detailRecord = detailRecord + this.cfonbToolService.createZone("2", OPERATION_CODE_PI, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 2);
            StringBuilder stringBuilder = new StringBuilder().append(detailRecord);
            String string2 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            detailRecord = stringBuilder.append(this.cfonbToolService.createZone("3", this.sequence++, string2, "N", 6)).toString();
            if (receiverBankDetails.getBank() == null) {
                throw new AxelorException(I18n.get((String)"Please fill the bank in the receiver bank details."), 1, new Object[0]);
            }
            detailRecord = detailRecord + this.cfonbToolService.createZone(I18n.get((String)"4 - Bank details type"), receiverBankDetails.getBank().getBankDetailsTypeSelect(), this.cfonbToolService.STATUS_DEPENDENT, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 1);
            detailRecord = detailRecord + this.cfonbToolService.createZone(I18n.get((String)"5 - Bank details IBAN"), this.getIban(receiverBankDetails), this.cfonbToolService.STATUS_DEPENDENT, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 34);
            int ownerNameLength = receiverBankDetails.getOwnerName().length();
            int adressLength = 105;
            if (ownerNameLength <= 35) {
                ownerNameLength = 35;
            } else if (35 < ownerNameLength && ownerNameLength <= 70) {
                adressLength = 105 - (ownerNameLength - 35);
            } else if (ownerNameLength > 70) {
                ownerNameLength = 70;
                adressLength = 70;
            }
            detailRecord = detailRecord + this.cfonbToolService.createZone(I18n.get((String)"6 - Bank details owner name"), receiverBankDetails.getOwnerName(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, ownerNameLength);
            detailRecord = detailRecord + this.cfonbToolService.createZone("7", this.getReceiverAddress(bankOrderLine), this.cfonbToolService.STATUS_DEPENDENT, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, adressLength);
            detailRecord = detailRecord + this.cfonbToolService.createZone("8", "", this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 17);
            Country receiverCountry = bankOrderLine.getReceiverCountry();
            String countryCode = "";
            if (receiverCountry != null) {
                countryCode = receiverCountry.getAlpha2Code();
            }
            detailRecord = detailRecord + this.cfonbToolService.createZone(I18n.get((String)"9 - Country code"), countryCode, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 2);
            detailRecord = detailRecord + this.cfonbToolService.createZone(I18n.get((String)"10 - Sequence"), bankOrderLine.getSequence(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 16);
            if (this.senderCurrency.equals((Object)this.bankOrderCurrency)) {
                qualifyngOfAmountStr = "T";
            } else {
                qualifyngOfAmountStr = this.qualityOfAmount;
                if (Strings.isNullOrEmpty((String)qualifyngOfAmountStr)) {
                    qualifyngOfAmountStr = "T";
                }
            }
            detailRecord = detailRecord + this.cfonbToolService.createZone("11", qualifyngOfAmountStr, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 1);
            StringBuilder stringBuilder2 = new StringBuilder().append(detailRecord);
            this.cfonbToolService.getClass();
            detailRecord = stringBuilder2.append(this.cfonbToolService.createZone("12", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 4)).toString();
            BigDecimal orderAmount = qualifyngOfAmountStr.equals("D") ? bankOrderLine.getCompanyCurrencyAmount() : bankOrderLine.getBankOrderAmount();
            StringBuilder stringBuilder3 = new StringBuilder().append(detailRecord);
            String string3 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            detailRecord = stringBuilder3.append(this.cfonbToolService.createZone("13", orderAmount, string3, "N", 14)).toString();
            StringBuilder stringBuilder4 = new StringBuilder().append(detailRecord);
            String string4 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            detailRecord = stringBuilder4.append(this.cfonbToolService.createZone("14", "2", string4, "N", 1)).toString();
            StringBuilder stringBuilder5 = new StringBuilder().append(detailRecord);
            this.cfonbToolService.getClass();
            detailRecord = stringBuilder5.append(this.cfonbToolService.createZone("15", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 1)).toString();
            BankOrderEconomicReason bankOrderEconomicReason = bankOrderLine.getBankOrderEconomicReason();
            String bankOrderEconomicReasonCode = "NNN";
            if (bankOrderEconomicReason != null) {
                bankOrderEconomicReasonCode = bankOrderEconomicReason.getCode();
            }
            detailRecord = detailRecord + this.cfonbToolService.createZone(I18n.get((String)"16 - Economic reason code"), bankOrderEconomicReasonCode, this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 3);
            StringBuilder stringBuilder6 = new StringBuilder().append(detailRecord);
            this.cfonbToolService.getClass();
            detailRecord = stringBuilder6.append(this.cfonbToolService.createZone("17", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 2)).toString();
            detailRecord = detailRecord + this.cfonbToolService.createZone(I18n.get((String)"18 - Payment mode select"), bankOrderLine.getPaymentModeSelect(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 1);
            StringBuilder stringBuilder7 = new StringBuilder().append(detailRecord);
            String string5 = I18n.get((String)"19 - Fees imputation mode");
            int n = bankOrderLine.getFeesImputationModeSelect();
            String string6 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            detailRecord = stringBuilder7.append(this.cfonbToolService.createZone(string5, n, string6, "N", 2)).toString();
            StringBuilder stringBuilder8 = new StringBuilder().append(detailRecord);
            this.cfonbToolService.getClass();
            detailRecord = stringBuilder8.append(this.cfonbToolService.createZone("23", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 57)).toString();
            detailRecord = detailRecord + this.cfonbToolService.createZone(I18n.get((String)"24-1 - Qualifying of date"), this.bankOrderFileFormat.getQualifyingOfDate(), this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 3);
            if (this.isMultiDates) {
                String bankOrderDate = "";
                if (bankOrderLine.getBankOrderDate() != null) {
                    bankOrderDate = bankOrderLine.getBankOrderDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
                }
                StringBuilder stringBuilder9 = new StringBuilder().append(detailRecord);
                String string7 = I18n.get((String)"24-2 - Date");
                String string8 = this.cfonbToolService.STATUS_MANDATORY;
                this.cfonbToolService.getClass();
                detailRecord = stringBuilder9.append(this.cfonbToolService.createZone(string7, bankOrderDate, string8, "N", 8)).toString();
            } else {
                StringBuilder stringBuilder10 = new StringBuilder().append(detailRecord);
                String string9 = I18n.get((String)"24-2 - Date");
                this.cfonbToolService.getClass();
                this.cfonbToolService.getClass();
                detailRecord = stringBuilder10.append(this.cfonbToolService.createZone(string9, "", "N", "N", 8)).toString();
            }
            if (this.isMultiCurrencies) {
                String bankOrderCurrencyCode = "";
                if (bankOrderLine.getBankOrderCurrency() != null) {
                    bankOrderCurrencyCode = bankOrderLine.getBankOrderCurrency().getCode();
                }
                detailRecord = detailRecord + this.cfonbToolService.createZone(I18n.get((String)"25 - Currency"), bankOrderCurrencyCode, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 3);
            } else {
                StringBuilder stringBuilder11 = new StringBuilder().append(detailRecord);
                String string10 = I18n.get((String)"25 - Currency");
                this.cfonbToolService.getClass();
                detailRecord = stringBuilder11.append(this.cfonbToolService.createZone(string10, "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 3)).toString();
            }
            this.cfonbToolService.toUpperCase(detailRecord);
            this.cfonbToolService.testLength(detailRecord, 320);
            return detailRecord;
        }
        catch (Exception e) {
            throw new AxelorException((Throwable)e, (Model)((Object)bankOrderLine), 1, I18n.get((String)"Anomaly has been detected during file generation for the detail record of the bank order line %s") + ": " + e.getMessage(), new Object[]{bankOrderLine.getSequence()});
        }
    }

    protected String getReceiverAddress(BankOrderLine bankOrderLine) throws AxelorException {
        String receiverAddress = bankOrderLine.getReceiverAddressStr();
        if (Strings.isNullOrEmpty((String)receiverAddress)) {
            if (this.receiverAddressRequired(bankOrderLine.getReceiverCountry())) {
                throw new AxelorException(5, String.format(I18n.get((String)"No address has been defined in the receiver %s"), bankOrderLine.getPartner().getFullName()));
            }
            return "";
        }
        return receiverAddress;
    }

    protected boolean receiverAddressRequired(Country country) {
        if (this.bankOrderFileFormat.getBankOrderFileFormatCountryList() == null || country == null) {
            return false;
        }
        for (BankOrderFileFormatCountry bankOrderFileFormatCountry : this.bankOrderFileFormat.getBankOrderFileFormatCountryList()) {
            if (!bankOrderFileFormatCountry.getCountry().equals((Object)country) || !bankOrderFileFormatCountry.getReceiverAddressRequired().booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected String createDependentReceiverBankRecord(BankOrderLine bankOrderLine) throws AxelorException {
        try {
            BankDetails receiverBankDetails = bankOrderLine.getReceiverBankDetails();
            Bank bank = receiverBankDetails.getBank();
            String string = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            String totalRecord = this.cfonbToolService.createZone("1", "05", string, "N", 2);
            totalRecord = totalRecord + this.cfonbToolService.createZone("2", OPERATION_CODE_PI, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 2);
            StringBuilder stringBuilder = new StringBuilder().append(totalRecord);
            String string2 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder.append(this.cfonbToolService.createZone("3", this.sequence++, string2, "N", 6)).toString();
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"4 - Bank name"), bank.getBankName(), this.cfonbToolService.STATUS_DEPENDENT, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 35);
            String bankAddress = "";
            if (bank.getBankName() != null && bank.getBankName().length() > 35) {
                bankAddress = bank.getBankName().substring(35) + " ";
            }
            if (receiverBankDetails.getBankAddress() != null) {
                bankAddress = bankAddress + receiverBankDetails.getBankAddress().getAddress();
            }
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"5 - Bank address"), bankAddress, this.cfonbToolService.STATUS_DEPENDENT, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 105);
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"6 - Bank code"), bank.getCode(), this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 11);
            String countryCode = "";
            if (bank.getCountry() != null) {
                countryCode = bank.getCountry().getAlpha2Code();
            }
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"7 - Country code"), countryCode, this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 2);
            StringBuilder stringBuilder2 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder2.append(this.cfonbToolService.createZone("8", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 157)).toString();
            this.cfonbToolService.toUpperCase(totalRecord);
            this.cfonbToolService.testLength(totalRecord, 320);
            return totalRecord;
        }
        catch (Exception e) {
            throw new AxelorException(e.getCause(), (Model)((Object)bankOrderLine), 1, I18n.get((String)"Anomaly has been detected during file generation for the beneficiary bank detail record of the bank order line %s") + ": " + e.getMessage(), new Object[]{bankOrderLine.getSequence()});
        }
    }

    protected String createOptionnalFurtherInformationRecord(BankOrderLine bankOrderLine) throws AxelorException {
        try {
            String string = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            String totalRecord = this.cfonbToolService.createZone("1", "07", string, "N", 2);
            totalRecord = totalRecord + this.cfonbToolService.createZone("2", OPERATION_CODE_PI, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 2);
            StringBuilder stringBuilder = new StringBuilder().append(totalRecord);
            String string2 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder.append(this.cfonbToolService.createZone("3", this.sequence++, string2, "N", 6)).toString();
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"4-1 - Payment Reason 1"), bankOrderLine.getPaymentReasonLine1(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 35);
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"4-2 - Payment Reason 2"), bankOrderLine.getPaymentReasonLine2(), this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 35);
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"4-3 - Payment Reason 3"), bankOrderLine.getPaymentReasonLine3(), this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 35);
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"4-4 - Payment Reason 4"), bankOrderLine.getPaymentReasonLine4(), this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 35);
            StringBuilder stringBuilder2 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder2.append(this.cfonbToolService.createZone("5", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 1)).toString();
            StringBuilder stringBuilder3 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder3.append(this.cfonbToolService.createZone("6", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 16)).toString();
            StringBuilder stringBuilder4 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder4.append(this.cfonbToolService.createZone("7", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 8)).toString();
            StringBuilder stringBuilder5 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder5.append(this.cfonbToolService.createZone("8", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 12)).toString();
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"9-1 - Special instructions 1"), bankOrderLine.getSpecialInstructionsLine1(), this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 35);
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"9-2 - Special instructions 2"), bankOrderLine.getSpecialInstructionsLine2(), this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 35);
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"9-3 - Special instructions 3"), bankOrderLine.getSpecialInstructionsLine3(), this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 35);
            StringBuilder stringBuilder6 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder6.append(this.cfonbToolService.createZone("8", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 28)).toString();
            this.cfonbToolService.toUpperCase(totalRecord);
            this.cfonbToolService.testLength(totalRecord, 320);
            return totalRecord;
        }
        catch (Exception e) {
            throw new AxelorException((Throwable)e, (Model)((Object)bankOrderLine), 1, I18n.get((String)"Anomaly has been detected during file generation for the further information detail record of the bank order line %s") + ": " + e.getMessage(), new Object[]{bankOrderLine.getSequence()});
        }
    }

    protected String computePaymentReason(BankOrderLine bankOrderLine) {
        String paymentReason = "";
        if (!Strings.isNullOrEmpty((String)bankOrderLine.getReceiverReference())) {
            paymentReason = paymentReason + bankOrderLine.getReceiverReference();
        }
        if (!Strings.isNullOrEmpty((String)bankOrderLine.getReceiverLabel())) {
            if (!Strings.isNullOrEmpty((String)paymentReason)) {
                paymentReason = paymentReason + "/";
            }
            paymentReason = paymentReason + bankOrderLine.getReceiverLabel();
        }
        return paymentReason;
    }

    protected String createTotalRecord() throws AxelorException {
        try {
            String string = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            String totalRecord = this.cfonbToolService.createZone("1", "08", string, "N", 2);
            totalRecord = totalRecord + this.cfonbToolService.createZone("2", OPERATION_CODE_PI, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 2);
            StringBuilder stringBuilder = new StringBuilder().append(totalRecord);
            String string2 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder.append(this.cfonbToolService.createZone("3", this.sequence, string2, "N", 6)).toString();
            StringBuilder stringBuilder2 = new StringBuilder().append(totalRecord);
            String string3 = this.generationDateTime.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            String string4 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder2.append(this.cfonbToolService.createZone("4", string3, string4, "N", 8)).toString();
            StringBuilder stringBuilder3 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder3.append(this.cfonbToolService.createZone("5", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 140)).toString();
            StringBuilder stringBuilder4 = new StringBuilder().append(totalRecord);
            String string5 = I18n.get((String)"6 - Registration code");
            String string6 = this.cfonbToolService.STATUS_DEPENDENT;
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder4.append(this.cfonbToolService.createZone(string5, this.registrationCode, string6, "N", 14)).toString();
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"7 - Sequence"), this.bankOrderSeq, this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 16);
            StringBuilder stringBuilder5 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder5.append(this.cfonbToolService.createZone("8", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 11)).toString();
            StringBuilder stringBuilder6 = new StringBuilder().append(totalRecord);
            String string7 = I18n.get((String)"9 - Bank details type");
            int n = this.senderBankDetails.getBank().getBankDetailsTypeSelect();
            String string8 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder6.append(this.cfonbToolService.createZone(string7, n, string8, "N", 1)).toString();
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"10 - Bank details IBAN"), this.getIban(this.senderBankDetails), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 34);
            totalRecord = totalRecord + this.cfonbToolService.createZone(I18n.get((String)"11 - Bank details code"), this.senderCurrency.getCode(), this.cfonbToolService.STATUS_MANDATORY, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 3);
            totalRecord = totalRecord + this.cfonbToolService.createZone("12", "", this.cfonbToolService.STATUS_OPTIONAL, this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 16);
            StringBuilder stringBuilder7 = new StringBuilder().append(totalRecord);
            String string9 = I18n.get((String)"13 - Total");
            String string10 = this.cfonbToolService.STATUS_MANDATORY;
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder7.append(this.cfonbToolService.createZone(string9, this.arithmeticTotal, string10, "N", 18)).toString();
            StringBuilder stringBuilder8 = new StringBuilder().append(totalRecord);
            this.cfonbToolService.getClass();
            totalRecord = stringBuilder8.append(this.cfonbToolService.createZone("14", "", "N", this.cfonbToolService.FORMAT_ALPHA_NUMERIC, 49)).toString();
            this.cfonbToolService.toUpperCase(totalRecord);
            this.cfonbToolService.testLength(totalRecord, 320);
            return totalRecord;
        }
        catch (Exception e) {
            throw new AxelorException((Throwable)e, 1, I18n.get((String)"Anomaly has been detected during file generation for the total record of the bank order %s") + ": " + e.getMessage(), new Object[]{this.bankOrderSeq});
        }
    }
}

