/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankreconciliation;

import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.bankpayment.db.BankReconciliationLine;
import com.axelor.apps.bankpayment.db.BankStatementLine;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import java.math.BigDecimal;
import java.time.LocalDate;

public class BankReconciliationLineService {
    public BankReconciliationLine createBankReconciliationLine(LocalDate effectDate, BigDecimal debit, BigDecimal credit, String name, String reference, BankStatementLine bankStatementLine, MoveLine moveLine) {
        BankReconciliationLine bankReconciliationLine = new BankReconciliationLine();
        bankReconciliationLine.setEffectDate(effectDate);
        bankReconciliationLine.setDebit(debit);
        bankReconciliationLine.setCredit(credit);
        bankReconciliationLine.setName(name);
        bankReconciliationLine.setReference(reference);
        bankReconciliationLine.setBankStatementLine(bankStatementLine);
        bankReconciliationLine.setMoveLine(moveLine);
        bankReconciliationLine.setIsPosted(false);
        return bankReconciliationLine;
    }

    public BankReconciliationLine createBankReconciliationLine(BankStatementLine bankStatementLine) {
        return this.createBankReconciliationLine(bankStatementLine.getValueDate(), bankStatementLine.getDebit(), bankStatementLine.getCredit(), bankStatementLine.getDescription(), bankStatementLine.getReference(), bankStatementLine, null);
    }

    public void checkAmount(BankReconciliationLine bankReconciliationLine) throws AxelorException {
        MoveLine moveLine = bankReconciliationLine.getMoveLine();
        BigDecimal bankDebit = bankReconciliationLine.getDebit();
        BigDecimal bankCredit = bankReconciliationLine.getCredit();
        BigDecimal moveLineDebit = moveLine.getDebit();
        BigDecimal moveLineCredit = moveLine.getCredit();
        if (bankDebit.add(bankCredit).compareTo(BigDecimal.ZERO) == 0) {
            throw new AxelorException((Model)((Object)bankReconciliationLine), 4, I18n.get((String)"%s : Bank statement line %s amount can't be null"), new Object[]{I18n.get((String)"Warning !"), bankReconciliationLine.getReference() != null ? bankReconciliationLine.getReference() : ""});
        }
        if (!(bankDebit.compareTo(BigDecimal.ZERO) > 0 && moveLineCredit.compareTo(BigDecimal.ZERO) > 0 && bankDebit.compareTo(moveLineCredit.subtract(moveLine.getBankReconciledAmount())) == 0 || bankCredit.compareTo(BigDecimal.ZERO) > 0 && moveLineDebit.compareTo(BigDecimal.ZERO) > 0 && bankCredit.compareTo(moveLineDebit.subtract(moveLine.getBankReconciledAmount())) == 0)) {
            throw new AxelorException((Model)((Object)bankReconciliationLine), 4, I18n.get((String)"%s : MoveLine amount is not equals with bank statement line %s"), new Object[]{I18n.get((String)"Warning !"), bankReconciliationLine.getReference() != null ? bankReconciliationLine.getReference() : ""});
        }
    }
}

