/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankreconciliation;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountManagement;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.repo.AccountManagementRepository;
import com.axelor.apps.account.db.repo.AccountRepository;
import com.axelor.apps.account.db.repo.JournalRepository;
import com.axelor.apps.account.service.AccountService;
import com.axelor.apps.bankpayment.db.BankReconciliation;
import com.axelor.apps.bankpayment.db.BankReconciliationLine;
import com.axelor.apps.bankpayment.db.BankStatement;
import com.axelor.apps.bankpayment.db.BankStatementFileFormat;
import com.axelor.apps.bankpayment.db.repo.BankReconciliationRepository;
import com.axelor.apps.bankpayment.service.bankreconciliation.load.BankReconciliationLoadService;
import com.axelor.apps.bankpayment.service.bankreconciliation.load.afb120.BankReconciliationLoadAFB120Service;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.service.BankDetailsService;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BankReconciliationService {
    protected BankReconciliationRepository bankReconciliationRepository;
    protected AccountService accountService;
    protected AccountManagementRepository accountManagementRepository;

    @Inject
    public BankReconciliationService(BankReconciliationRepository bankReconciliationRepository, AccountService accountService, AccountManagementRepository accountManagementRepository) {
        this.bankReconciliationRepository = bankReconciliationRepository;
        this.accountService = accountService;
        this.accountManagementRepository = accountManagementRepository;
    }

    @Transactional
    public void compute(BankReconciliation bankReconciliation) {
        BigDecimal totalPaid = BigDecimal.ZERO;
        BigDecimal totalCashed = BigDecimal.ZERO;
        for (BankReconciliationLine bankReconciliationLine : bankReconciliation.getBankReconciliationLineList()) {
            totalPaid = totalPaid.add(bankReconciliationLine.getDebit());
            totalCashed = totalCashed.add(bankReconciliationLine.getCredit());
        }
        bankReconciliation.setTotalPaid(totalPaid);
        bankReconciliation.setTotalCashed(totalCashed);
        Account cashAccount = bankReconciliation.getCashAccount();
        if (cashAccount != null) {
            bankReconciliation.setAccountBalance(this.accountService.computeBalance(cashAccount, AccountService.BALANCE_TYPE_DEBIT_BALANCE.intValue()));
        }
        bankReconciliation.setComputedBalance(bankReconciliation.getAccountBalance().add(totalCashed).subtract(totalPaid));
    }

    public String createDomainForBankDetails(BankReconciliation bankReconciliation) {
        return ((BankDetailsService)Beans.get(BankDetailsService.class)).getActiveCompanyBankDetails(bankReconciliation.getCompany(), bankReconciliation.getCurrency());
    }

    @Transactional
    public void loadBankStatement(BankReconciliation bankReconciliation) {
        this.loadBankStatement(bankReconciliation, true);
    }

    @Transactional
    public void loadBankStatement(BankReconciliation bankReconciliation, boolean includeBankStatement) {
        BankStatement bankStatement = bankReconciliation.getBankStatement();
        BankStatementFileFormat bankStatementFileFormat = bankStatement.getBankStatementFileFormat();
        switch (bankStatementFileFormat.getStatementFileFormatSelect()) {
            case "camt.xxx.cfonb120.rep": 
            case "camt.xxx.cfonb120.stm": {
                ((BankReconciliationLoadAFB120Service)Beans.get(BankReconciliationLoadAFB120Service.class)).loadBankStatement(bankReconciliation, includeBankStatement);
                break;
            }
            default: {
                ((BankReconciliationLoadService)Beans.get(BankReconciliationLoadService.class)).loadBankStatement(bankReconciliation, includeBankStatement);
            }
        }
        this.compute(bankReconciliation);
        this.bankReconciliationRepository.save((Model)((Object)bankReconciliation));
    }

    public String getJournalDomain(BankReconciliation bankReconciliation) {
        String journalIds = null;
        HashSet<String> journalIdSet = new HashSet<String>();
        journalIdSet.addAll(this.getAccountManagementJournals(bankReconciliation));
        if (bankReconciliation.getBankDetails().getJournal() != null) {
            journalIdSet.add(bankReconciliation.getBankDetails().getJournal().getId().toString());
        }
        journalIds = String.join((CharSequence)",", journalIdSet);
        return journalIds;
    }

    protected Set<String> getAccountManagementJournals(BankReconciliation bankReconciliation) {
        HashSet<String> journalIdSet = new HashSet<String>();
        Account cashAccount = bankReconciliation.getCashAccount();
        List accountManagementList = new ArrayList();
        accountManagementList = cashAccount != null ? this.accountManagementRepository.all().filter("self.bankDetails = ?1 and self.cashAccount = ?2", new Object[]{bankReconciliation.getBankDetails(), cashAccount}).fetch() : this.accountManagementRepository.all().filter("self.bankDetails = ?1", new Object[]{bankReconciliation.getBankDetails()}).fetch();
        for (AccountManagement accountManagement : accountManagementList) {
            if (accountManagement.getJournal() == null) continue;
            journalIdSet.add(accountManagement.getJournal().getId().toString());
        }
        return journalIdSet;
    }

    public Journal getJournal(BankReconciliation bankReconciliation) {
        Journal journal = null;
        String journalIds = String.join((CharSequence)",", this.getAccountManagementJournals(bankReconciliation));
        if (bankReconciliation.getBankDetails().getJournal() != null) {
            journal = bankReconciliation.getBankDetails().getJournal();
        } else if (!Strings.isNullOrEmpty((String)journalIds) && journalIds.split(",").length == 1) {
            journal = (Journal)((JournalRepository)Beans.get(JournalRepository.class)).find(Long.valueOf(Long.parseLong(journalIds)));
        }
        return journal;
    }

    public String getCashAccountDomain(BankReconciliation bankReconciliation) {
        String cashAccountIds = null;
        HashSet<String> cashAccountIdSet = new HashSet<String>();
        cashAccountIdSet.addAll(this.getAccountManagementCashAccounts(bankReconciliation));
        if (bankReconciliation.getBankDetails().getBankAccount() != null) {
            cashAccountIdSet.add(bankReconciliation.getBankDetails().getBankAccount().getId().toString());
        }
        cashAccountIds = String.join((CharSequence)",", cashAccountIdSet);
        return cashAccountIds;
    }

    protected Set<String> getAccountManagementCashAccounts(BankReconciliation bankReconciliation) {
        Journal journal = bankReconciliation.getJournal();
        HashSet<String> cashAccountIdSet = new HashSet<String>();
        BankDetails bankDetails = bankReconciliation.getBankDetails();
        List accountManagementList = journal != null ? this.accountManagementRepository.all().filter("self.bankDetails = ?1 AND self.journal = ?2", new Object[]{bankDetails, journal}).fetch() : this.accountManagementRepository.all().filter("self.bankDetails = ?1", new Object[]{bankDetails}).fetch();
        for (AccountManagement accountManagement : accountManagementList) {
            if (accountManagement.getCashAccount() == null) continue;
            cashAccountIdSet.add(accountManagement.getCashAccount().getId().toString());
        }
        return cashAccountIdSet;
    }

    public Account getCashAccount(BankReconciliation bankReconciliation) {
        Account cashAccount = null;
        String cashAccountIds = String.join((CharSequence)",", this.getAccountManagementCashAccounts(bankReconciliation));
        if (bankReconciliation.getBankDetails().getBankAccount() != null) {
            cashAccount = bankReconciliation.getBankDetails().getBankAccount();
        } else if (!Strings.isNullOrEmpty((String)cashAccountIds) && cashAccountIds.split(",").length == 1) {
            cashAccount = (Account)((AccountRepository)Beans.get(AccountRepository.class)).find(Long.valueOf(Long.parseLong(cashAccountIds)));
        }
        return cashAccount;
    }
}

