/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankreconciliation.load;

import com.axelor.apps.bankpayment.db.BankReconciliation;
import com.axelor.apps.bankpayment.db.BankStatement;
import com.axelor.apps.bankpayment.db.BankStatementLine;
import com.axelor.apps.bankpayment.service.bankreconciliation.BankReconciliationLineService;
import com.axelor.db.JPA;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.List;

public class BankReconciliationLoadService {
    protected BankReconciliationLineService bankReconciliationLineService;

    @Inject
    public BankReconciliationLoadService(BankReconciliationLineService bankReconciliationLineService) {
        this.bankReconciliationLineService = bankReconciliationLineService;
    }

    @Transactional
    public void loadBankStatement(BankReconciliation bankReconciliation, boolean includeBankStatement) {
        this.loadBankStatementLines(bankReconciliation, includeBankStatement);
    }

    @Transactional
    public void loadBankStatementLines(BankReconciliation bankReconciliation) {
        this.loadBankStatementLines(bankReconciliation, true);
    }

    @Transactional
    public void loadBankStatementLines(BankReconciliation bankReconciliation, boolean includeBankStatement) {
        List<BankStatementLine> bankStatementLineList = this.getBankStatementLines(bankReconciliation, includeBankStatement);
        if (bankStatementLineList != null) {
            for (BankStatementLine bankStatementLine : bankStatementLineList) {
                bankReconciliation.addBankReconciliationLineListItem(this.bankReconciliationLineService.createBankReconciliationLine(bankStatementLine));
            }
        }
    }

    protected String getBankStatementLinesFilter(boolean includeOtherBankStatements, boolean includeBankStatement) {
        String filter = !includeOtherBankStatements && includeBankStatement ? "self.bankDetails = :bankDetails and self.currency = :currency and self.amountRemainToReconcile > 0 and self.bankStatement.statusSelect = :statusImported and self.bankStatement = :bankStatement" : (includeOtherBankStatements && includeBankStatement ? "self.bankDetails = :bankDetails and self.currency = :currency and self.amountRemainToReconcile > 0 and self.bankStatement.statusSelect = :statusImported and self.bankStatement.bankStatementFileFormat = :bankStatementFileFormat" : "self.bankDetails = :bankDetails and self.currency = :currency and self.amountRemainToReconcile > 0 and self.bankStatement.statusSelect = :statusImported and self.bankStatement.bankStatementFileFormat = :bankStatementFileFormat and self.bankStatement != :bankStatement");
        return filter;
    }

    protected List<BankStatementLine> getBankStatementLines(BankReconciliation bankReconciliation, boolean includeBankStatement) {
        BankStatement bankStatement = bankReconciliation.getBankStatement();
        return JPA.all(BankStatementLine.class).filter(this.getBankStatementLinesFilter(bankReconciliation.getIncludeOtherBankStatements(), includeBankStatement)).bind("bankDetails", (Object)bankReconciliation.getBankDetails()).bind("currency", (Object)bankReconciliation.getCurrency()).bind("statusImported", (Object)2).bind("bankStatement", (Object)bankStatement).bind("bankStatementFileFormat", (Object)bankStatement.getBankStatementFileFormat()).order("valueDate").order("sequence").fetch();
    }
}

