/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankreconciliation.load.afb120;

import com.axelor.apps.bankpayment.db.BankReconciliation;
import com.axelor.apps.bankpayment.db.BankStatement;
import com.axelor.apps.bankpayment.db.BankStatementLine;
import com.axelor.apps.bankpayment.db.BankStatementLineAFB120;
import com.axelor.apps.bankpayment.db.repo.BankStatementLineAFB120Repository;
import com.axelor.apps.bankpayment.service.bankreconciliation.BankReconciliationLineService;
import com.axelor.apps.bankpayment.service.bankreconciliation.load.BankReconciliationLoadService;
import com.axelor.db.JPA;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.List;

public class BankReconciliationLoadAFB120Service
extends BankReconciliationLoadService {
    protected BankStatementLineAFB120Repository bankStatementLineAFB120Repository;

    @Inject
    public BankReconciliationLoadAFB120Service(BankReconciliationLineService bankReconciliationLineService, BankStatementLineAFB120Repository bankStatementLineAFB120Repository) {
        super(bankReconciliationLineService);
        this.bankStatementLineAFB120Repository = bankStatementLineAFB120Repository;
    }

    @Override
    @Transactional
    public void loadBankStatement(BankReconciliation bankReconciliation, boolean includeBankStatement) {
        BankStatementLine initialBalanceBankStatementLine = this.getInitialBalanceBankStatementLine(bankReconciliation, includeBankStatement);
        BankStatementLine finalBalanceBankStatementLine = this.getFinalBalanceBankStatementLine(bankReconciliation, includeBankStatement);
        if (initialBalanceBankStatementLine != null) {
            bankReconciliation.setStartingBalance(initialBalanceBankStatementLine.getCredit().subtract(initialBalanceBankStatementLine.getDebit()));
        }
        if (finalBalanceBankStatementLine != null) {
            bankReconciliation.setEndingBalance(finalBalanceBankStatementLine.getCredit().subtract(finalBalanceBankStatementLine.getDebit()));
        }
        this.loadBankStatementLines(bankReconciliation, includeBankStatement);
    }

    @Override
    @Transactional
    public void loadBankStatementLines(BankReconciliation bankReconciliation, boolean includeBankStatement) {
        List<BankStatementLineAFB120> bankStatementLineList = this.getBankStatementLinesAFB120(bankReconciliation, includeBankStatement);
        if (bankStatementLineList != null) {
            for (BankStatementLine bankStatementLine : bankStatementLineList) {
                bankReconciliation.addBankReconciliationLineListItem(this.bankReconciliationLineService.createBankReconciliationLine(bankStatementLine));
            }
        }
    }

    @Override
    protected String getBankStatementLinesFilter(boolean includeOtherBankStatements, boolean includeBankStatement) {
        return super.getBankStatementLinesFilter(includeOtherBankStatements, includeBankStatement) + " and self.lineTypeSelect = :lineTypeSelect";
    }

    protected List<BankStatementLineAFB120> getBankStatementLinesAFB120(BankReconciliation bankReconciliation, boolean includeBankStatement) {
        BankStatement bankStatement = bankReconciliation.getBankStatement();
        return JPA.all(BankStatementLineAFB120.class).filter(this.getBankStatementLinesFilter(bankReconciliation.getIncludeOtherBankStatements(), includeBankStatement)).bind("bankDetails", (Object)bankReconciliation.getBankDetails()).bind("currency", (Object)bankReconciliation.getCurrency()).bind("statusImported", (Object)2).bind("bankStatement", (Object)bankStatement).bind("bankStatementFileFormat", (Object)bankStatement.getBankStatementFileFormat()).bind("lineTypeSelect", (Object)2).order("valueDate").order("sequence").fetch();
    }

    protected BankStatementLine getInitialBalanceBankStatementLine(BankReconciliation bankReconciliation, boolean includeBankStatement) {
        BankStatement bankStatement = bankReconciliation.getBankStatement();
        return (BankStatementLine)((Object)JPA.all(BankStatementLineAFB120.class).filter(this.getBankStatementLinesFilter(bankReconciliation.getIncludeOtherBankStatements(), includeBankStatement)).bind("bankDetails", (Object)bankReconciliation.getBankDetails()).bind("currency", (Object)bankReconciliation.getCurrency()).bind("statusImported", (Object)2).bind("bankStatement", (Object)bankStatement).bind("bankStatementFileFormat", (Object)bankStatement.getBankStatementFileFormat()).bind("lineTypeSelect", (Object)1).order("operationDate").order("sequence").fetchOne());
    }

    protected BankStatementLine getFinalBalanceBankStatementLine(BankReconciliation bankReconciliation, boolean includeBankStatement) {
        BankStatement bankStatement = bankReconciliation.getBankStatement();
        return (BankStatementLine)((Object)JPA.all(BankStatementLineAFB120.class).filter(this.getBankStatementLinesFilter(bankReconciliation.getIncludeOtherBankStatements(), includeBankStatement)).bind("bankDetails", (Object)bankReconciliation.getBankDetails()).bind("currency", (Object)bankReconciliation.getCurrency()).bind("statusImported", (Object)2).bind("bankStatement", (Object)bankStatement).bind("bankStatementFileFormat", (Object)bankStatement.getBankStatementFileFormat()).bind("lineTypeSelect", (Object)3).order("-operationDate").order("-sequence").fetchOne());
    }
}

