/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.bankpayment.service.bankstatement;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.bankpayment.db.BankStatement;
import com.axelor.apps.bankpayment.db.BankStatementFileFormat;
import com.axelor.apps.bankpayment.db.repo.BankStatementRepository;
import com.axelor.apps.bankpayment.service.bankstatement.file.afb120.BankStatementFileAFB120Service;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;

public class BankStatementService {
    protected BankStatementRepository bankStatementRepository;

    @Inject
    public BankStatementService(BankStatementRepository bankStatementRepository) {
        this.bankStatementRepository = bankStatementRepository;
    }

    public void runImport(BankStatement bankStatement, boolean alertIfFormatNotSupported) throws IOException, AxelorException {
        if ((bankStatement = this.find(bankStatement)).getBankStatementFile() == null) {
            throw new AxelorException(I18n.get((String)"Missing bank statement file"), 1, new Object[0]);
        }
        if (bankStatement.getBankStatementFileFormat() == null) {
            throw new AxelorException(I18n.get((String)"Missing bank statement file format"), 1, new Object[0]);
        }
        BankStatementFileFormat bankStatementFileFormat = bankStatement.getBankStatementFileFormat();
        switch (bankStatementFileFormat.getStatementFileFormatSelect()) {
            case "camt.xxx.cfonb120.rep": 
            case "camt.xxx.cfonb120.stm": {
                ((BankStatementFileAFB120Service)Beans.get(BankStatementFileAFB120Service.class)).process(bankStatement);
                this.updateStatus(bankStatement);
                break;
            }
            default: {
                if (!alertIfFormatNotSupported) break;
                throw new AxelorException(I18n.get((String)"Unknown format for file import process"), 5, new Object[0]);
            }
        }
    }

    @Transactional
    public void updateStatus(BankStatement bankStatement) {
        bankStatement = this.find(bankStatement);
        bankStatement.setStatusSelect(2);
        this.bankStatementRepository.save((Model)((Object)bankStatement));
    }

    public String print(BankStatement bankStatement) throws AxelorException {
        String reportName;
        switch (bankStatement.getBankStatementFileFormat().getStatementFileFormatSelect()) {
            case "camt.xxx.cfonb120.rep": 
            case "camt.xxx.cfonb120.stm": {
                reportName = "BankStatementAFB120.rptdesign";
                break;
            }
            default: {
                throw new AxelorException(I18n.get((String)"Unknown format for file import process"), 5, new Object[0]);
            }
        }
        return ReportFactory.createReport((String)reportName, (String)(bankStatement.getName() + "-${date}")).addParam("BankStatementId", (Object)bankStatement.getId()).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addParam("Timezone", (Object)this.getTimezone(bankStatement)).addFormat("pdf").toAttach((Model)((Object)bankStatement)).generate().getFileLink();
    }

    private String getTimezone(BankStatement bankStatement) {
        if (bankStatement.getEbicsPartner() == null || bankStatement.getEbicsPartner().getDefaultSignatoryEbicsUser() == null || bankStatement.getEbicsPartner().getDefaultSignatoryEbicsUser().getAssociatedUser() == null || bankStatement.getEbicsPartner().getDefaultSignatoryEbicsUser().getAssociatedUser().getActiveCompany() == null) {
            return null;
        }
        return bankStatement.getEbicsPartner().getDefaultSignatoryEbicsUser().getAssociatedUser().getActiveCompany().getTimezone();
    }

    public BankStatement find(BankStatement bankStatement) {
        return JPA.em().contains((Object)bankStatement) ? bankStatement : (BankStatement)((Object)this.bankStatementRepository.find(bankStatement.getId()));
    }
}

